<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * PatientsUnits Controller
 *
 * @property \App\Model\Table\PatientsUnitsTable $PatientsUnits
 */
class PatientsUnitsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Units', 'Patients']
        ];
        $patientsUnits = $this->paginate($this->PatientsUnits);

        $this->set(compact('patientsUnits'));
        $this->set('_serialize', ['patientsUnits']);
    }

    /**
     * View method
     *
     * @param string|null $id Patients Unit id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $patientsUnit = $this->PatientsUnits->get($id, [
            'contain' => ['Units', 'Patients']
        ]);

        $this->set('patientsUnit', $patientsUnit);
        $this->set('_serialize', ['patientsUnit']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $patientsUnit = $this->PatientsUnits->newEntity();
        if ($this->request->is('post')) {
            $patientsUnit = $this->PatientsUnits->patchEntity($patientsUnit, $this->request->data);
            if ($this->PatientsUnits->save($patientsUnit)) {
                $this->Flash->success(__('The patients unit has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The patients unit could not be saved. Please, try again.'));
            }
        }
        $units = $this->PatientsUnits->Units->find('list', ['limit' => 200]);
        $patients = $this->PatientsUnits->Patients->find('list', ['limit' => 200]);
        $this->set(compact('patientsUnit', 'units', 'patients'));
        $this->set('_serialize', ['patientsUnit']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Patients Unit id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $patientsUnit = $this->PatientsUnits->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $patientsUnit = $this->PatientsUnits->patchEntity($patientsUnit, $this->request->data);
            if ($this->PatientsUnits->save($patientsUnit)) {
                $this->Flash->success(__('The patients unit has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The patients unit could not be saved. Please, try again.'));
            }
        }
        $units = $this->PatientsUnits->Units->find('list', ['limit' => 200]);
        $patients = $this->PatientsUnits->Patients->find('list', ['limit' => 200]);
        $this->set(compact('patientsUnit', 'units', 'patients'));
        $this->set('_serialize', ['patientsUnit']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Patients Unit id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $patientsUnit = $this->PatientsUnits->get($id);
        if ($this->PatientsUnits->delete($patientsUnit)) {
            $this->Flash->success(__('The patients unit has been deleted.'));
        } else {
            $this->Flash->error(__('The patients unit could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
