<?php
namespace App\Controller\Component;

use Cake\Controller\Component;
use Cake\Log\Log;

/**
 * Authorization component
 */
class PermissionComponent extends Component
{
    public $allow = [
        "Administrador" =>
        [
            "users" => ["add", "index", "view", "edit", "delete", "activate", "desactivate", "login", "addUserToUnit", "listUsersFromUnit"],
            "units" => ["add", "index", "view", "edit", "delete", "activate", 'desactivate', 'listUsers', "attachUsers", "linkUserToUnit", "unlinkUserFromUnit"],
            "groups" => ["add", "index", "view", "edit", "delete"],
            "signs" => ["add", "index", "view", "edit", "delete"],
            "specialties" => ["index", "add", "view", "edit"],
        ],
        "Qualidade" =>
        [
            "users" => ["index", "add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"],
            "units" => ["index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'],
            "groups" => ["view"],
            "signs" => ["index", 'add', "view", "edit", "delete"],
            "patients" => ["index", "add", "view", "edit", "listPatientsFromUnit", 'delete', "selectPatient", "selectPatientEmergency"],
            "specialties" => ["index", "add", "view", "edit", "listPatientsFromUnit"],
            "sectors" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "rooms" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "professionals" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "hospitalizations" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization', 'getProfessionals', 'search'],
            "MedicalOpinionRequests" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'],
            "MedicalOpinionAnswers" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailySafetyChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "SurgicalChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "Diagnostics" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "HealthInsurancePlans" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "Bundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "Origins" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailyBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "HistoricPatientMovements" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "PavPreventionBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "NutritionalAssessments" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "ApacheIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'dashboard'],
            "CribScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "IdentificationOfRisks" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SupportiveMeasures" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CardiacSurgeryChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "NasScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SofaEscores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SnapIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "TciTypes" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "Relatorios" => ["view", 'dashboard', 'nutritionalAssessments', 'bundleVesicalCateter'],
            "FugulinBradenScales" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SkinIntegrities" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],

        ]
        ,
        "Usuário" =>
        [
            "users" => ["add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"],
            "units" => ["index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'],
            "groups" => ["index", "view"],
            "signs" => ["index", 'add', "view", "edit", "delete"],
            "patients" => ["index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient", "selectPatientEmergency"],
            "specialties" => ["index", "add", "view", "edit", "listPatientsFromUnit"],
            "sectors" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "rooms" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "professionals" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "hospitalizations" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization', 'getProfessionals', 'search'],
            "MedicalOpinionRequests" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'],
            "MedicalOpinionAnswers" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailySafetyChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "SurgicalChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "Diagnostics" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "HealthInsurancePlans" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "Origins" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "Signs" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "Bundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailyBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "HistoricPatientMovements" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "PavPreventionBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "NutritionalAssessments" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "ApacheIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'dashboard'],
            "CribScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "IdentificationOfRisks" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SupportiveMeasures" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CardiacSurgeryChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "NasScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SofaEscores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SnapIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "TciTypes" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "Relatorios" => ["view", 'dashboard', 'nutritionalAssessments', 'bundleVesicalCateter'],
            "FugulinBradenScales" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SkinIntegrities" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
        ],

        "Médico" =>
        [
            "users" => ["add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"],
            "units" => ["index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'],
            "groups" => ["index", "view"],
            "signs" => ["index", 'add', "view", "edit", "delete"],
            "patients" => ["index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"],
            "specialties" => ["index", "add", "view", "edit", "listPatientsFromUnit"],
            "sectors" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "rooms" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "professionals" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "hospitalizations" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization'],
            "MedicalOpinionRequests" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'],
            "MedicalOpinionAnswers" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailySafetyChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "SurgicalChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "Diagnostics" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "Bundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailyBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "HistoricPatientMovements" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "PavPreventionBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "NutritionalAssessments" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "ApacheIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CribScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "IdentificationOfRisks" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SupportiveMeasures" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CardiacSurgeryChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "NasScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SofaEscores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SnapIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "TciTypes" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "FugulinBradenScales" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'desactivate'],
            "SkinIntegrities" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
        ],

        "Farmacêutico" =>
        [
            "users" => ["add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"],
            "units" => ["index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'],
            "groups" => ["index", "view"],
            "signs" => ["index", 'add', "view", "edit", "delete"],
            "patients" => ["index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"],
            "specialties" => ["index", "add", "view", "edit", "listPatientsFromUnit"],
            "sectors" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "rooms" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "professionals" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "hospitalizations" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization'],
            "MedicalOpinionRequests" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'],
            "MedicalOpinionAnswers" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailySafetyChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "SurgicalChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "Diagnostics" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "Bundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailyBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "HistoricPatientMovements" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "PavPreventionBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "NutritionalAssessments" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "ApacheIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CribScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "IdentificationOfRisks" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SupportiveMeasures" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CardiacSurgeryChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "NasScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SofaEscores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SnapIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "TciTypes" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
        ],

        "Enfermeiro" =>
        [
            "users" => ["add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"],
            "units" => ["index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'],
            "groups" => ["index", "view"],
            "signs" => ["index", 'add', "view", "edit", "delete"],
            "patients" => ["index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"],
            "specialties" => ["index", "add", "view", "edit", "listPatientsFromUnit"],
            "sectors" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "rooms" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "professionals" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "hospitalizations" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization'],
            "MedicalOpinionRequests" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'],
            "MedicalOpinionAnswers" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailySafetyChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "SurgicalChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "Diagnostics" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "Bundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailyBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "HistoricPatientMovements" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "PavPreventionBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "NutritionalAssessments" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "ApacheIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CribScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "IdentificationOfRisks" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SupportiveMeasures" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CardiacSurgeryChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "NasScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SofaEscores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SnapIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "TciTypes" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
        ],

        "Fisioterapeuta" =>
        [
            "users" => ["add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"],
            "units" => ["index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'],
            "groups" => ["index", "view"],
            "signs" => ["index", 'add', "view", "edit", "delete"],
            "patients" => ["index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"],
            "specialties" => ["index", "add", "view", "edit", "listPatientsFromUnit"],
            "sectors" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "rooms" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "professionals" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "hospitalizations" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization'],
            "MedicalOpinionRequests" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'],
            "MedicalOpinionAnswers" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailySafetyChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "SurgicalChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "Diagnostics" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "Bundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailyBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "HistoricPatientMovements" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "PavPreventionBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "NutritionalAssessments" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "ApacheIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CribScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "IdentificationOfRisks" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SupportiveMeasures" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CardiacSurgeryChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "NasScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SofaEscores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SnapIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "TciTypes" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
        ],

        "CCIH" =>
        [
            "users" => ["add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"],
            "units" => ["index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'],
            "groups" => ["index", "view"],
            "signs" => ["index", 'add', "view", "edit", "delete"],
            "patients" => ["index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"],
            "specialties" => ["index", "add", "view", "edit", "listPatientsFromUnit"],
            "sectors" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "rooms" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "professionals" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "hospitalizations" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization'],
            "MedicalOpinionRequests" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'],
            "MedicalOpinionAnswers" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailySafetyChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "SurgicalChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "Diagnostics" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "Bundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailyBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "HistoricPatientMovements" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "PavPreventionBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "NutritionalAssessments" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "ApacheIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CribScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "IdentificationOfRisks" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SupportiveMeasures" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CardiacSurgeryChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "NasScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SofaEscores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "TciTypes" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SnapIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
        ],

        "SIHDOT" =>
        [
            "users" => ["add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"],
            "units" => ["index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'],
            "groups" => ["index", "view"],
            "signs" => ["index", 'add', "view", "edit", "delete"],
            "patients" => ["index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"],
            "specialties" => ["index", "add", "view", "edit", "listPatientsFromUnit"],
            "sectors" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "rooms" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "professionals" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "hospitalizations" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization'],
            "MedicalOpinionRequests" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'],
            "MedicalOpinionAnswers" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailySafetyChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "SurgicalChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "Diagnostics" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "Bundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailyBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "HistoricPatientMovements" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "PavPreventionBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "NutritionalAssessments" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "ApacheIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CribScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "IdentificationOfRisks" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SupportiveMeasures" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CardiacSurgeryChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "NasScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SofaEscores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SnapIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
        ],

        "Administrativo" =>
        [
            "users" => ["add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"],
            "units" => ["index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'],
            "groups" => ["index", "view"],
            "signs" => ["index", 'add', "view", "edit", "delete"],
            "patients" => ["index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"],
            "specialties" => ["index", "add", "view", "edit", "listPatientsFromUnit"],
            "sectors" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "rooms" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "professionals" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "hospitalizations" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'selectHospitalization'],
            "MedicalOpinionRequests" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'toggleMedicalRequest'],
            "MedicalOpinionAnswers" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailySafetyChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "SurgicalChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "Diagnostics" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "Bundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "DailyBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "HistoricPatientMovements" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "PavPreventionBundles" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "NutritionalAssessments" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "ApacheIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CribScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "IdentificationOfRisks" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SupportiveMeasures" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "CardiacSurgeryChecklists" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate", 'activate', 'desactivate'],
            "NasScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SofaEscores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
            "SnapIiScores" => ["index", "add", "view", "edit", 'delete', "desactivate", "activate"],
        ],
    ];

    public $allowEditUser = [
        "Qualidade" => ["Qualidade", "Médico", "Farmacêutico", "Executivo"],
        "Usuário" => ["Usuário"],
        "Administrador" => ["Administrador", "Qualidade", "Médico", "Farmacêutico", "Executivo"],
    ];

    //verifica se o usuario tem permissao pra acessar a action
    public function hasPermission($role_name, $controller, $action)
    {

        if (in_array($action, $this->allow[$role_name][$controller]))
        {
            Log::write('debug', "hasPermission = true, controller = " . $controller . ", action = " .
                $action . ", role_name = " . $role_name);
            return true;
        }
        else
        {
            Log::write('debug', "hasPermission = false, controller = " . $controller . ", action = " .
                $action . ", role_name = " . $role_name);
            return false;
        }
    }

    //verifica se o usuario pode editar outro usuario
    public function canEditUser($user_role_name, $target_role_name)
    {

        if (in_array($target_role_name, $this->allowEditUser[$user_role_name]))
        {
            Log::write('debug', "canEditUser = true, user_role_name = " . $user_role_name . ", target_role_name = "
                . $target_role_name);
            return true;
        }
        else
        {
            Log::write('debug', "canEditUser = false, user_role_name = " . $user_role_name . ", target_role_name = "
                . $target_role_name);
            return false;
        }
    }
}
