<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Patient Entity.
 *
 * @property int $id
 * @property string $nome
 * @property string $email
 * @property string $document_number
 * @property \Cake\I18n\Time $birthday
 * @property string $nationality
 * @property string $profession
 * @property string $civil_status
 * @property string $race
 * @property string $medical_record_number
 * @property string $street
 * @property string $district
 * @property string $cep
 * @property string $city
 * @property string $country
 * @property string $mother_name
 * @property string $father_name
 * @property string $responsible_name
 * @property string $religion
 * @property string $medical_care
 * @property bool $is_active
 * @property \App\Model\Entity\Allergy[] $allergies
 * @property \App\Model\Entity\Diagnostic[] $diagnostics
 * @property \App\Model\Entity\GlasgowComaScale[] $glasgow_coma_scales
 * @property \App\Model\Entity\Hospitalization[] $hospitalizations
 * @property \App\Model\Entity\Responsible[] $responsibles
 * @property \App\Model\Entity\Screening[] $screenings
 * @property \App\Model\Entity\Telephone[] $telephones
 */
class Patient extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
