<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * DailySafetyChecklist Entity.
 *
 * @property int $id
 * @property \Cake\I18n\Time $created
 * @property \Cake\I18n\Time $modified
 * @property string $cabeceira_de_leito_elevado
 * @property string $prevenção_de_lesao_aguda_de_mucosa_gastrica
 * @property string $profilaxia_de_tev
 * @property string $suporte_nutricional
 * @property bool $protocolo_de_controle_glicemico
 * @property string $total_de_insulina_sub_cutanea_nas_24_horas
 * @property bool $fez_insulina_venosa
 * @property string $total_de_insulina_venosa_nas_24_horas
 * @property int $total_glicemias_menor_que_60
 * @property bool $sedacao
 * @property bool $sob_analgesia
 * @property bool $delirium
 * @property bool $teve_dor_nas_ultimas_24_horas
 * @property bool $ventilacao_mecanica_invasiva
 * @property bool $pa2_fio2_menor_que_300
 * @property bool $volume_corrente_menor_que_8
 * @property bool $pressao_de_plato_menor_que_30
 * @property bool $iniciar_desmane
 * @property bool $iniciar_peca_t
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 * @property bool $cateter_venoso_central
 * @property bool $cateter_venoso_central_can_be_removed
 * @property bool $cateter_vesical_de_demora
 * @property bool $cateter_vesical_de_demora_can_be_removed
 * @property bool $antibioticos
 * @property bool $antibioticos_can_be_removed
 * @property bool $corticoesteroides
 * @property bool $corticoesteroides_can_be_removed
 * @property bool $cateter_arterial_can_be_removed
 * @property bool $cateter_arterial
 * @property bool $total_de_afericoes
 * @property bool $afericoes_maior_180
 * @property bool $fez_insulina_ultimas_24_h
 * @property string $total_insulina_ultimas_24_h
 * @property bool $total_afericoes_glicemicas
 * @property bool $total_glicemias_maior_que_180
 * @property bool $protocolo_glicemico
 * @property bool $uso_de_sedacao
 * @property bool $sedacao_dentro_da_meta
 * @property string $interrupcao_sedacao
 * @property bool $is_active
 * @property bool $protocolo_higienico_oral
 * @property bool $aspiracao_da_secrecao
 * @property string $necessidade_de_profilaxia
 * @property bool $atingiu_vet_pleno
 * @property string $via_de_nutricao
 * @property bool $avaliacao_delirium_pelo_camicu
 * @property bool $paciente_sob_ventilacao_espontanea
 * @property \App\Model\Entity\Procedure[] $procedures
 */
class DailySafetyChecklist extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
