<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * OtherDiagnosticsComorbidities Controller
 *
 * @property \App\Model\Table\OtherDiagnosticsComorbiditiesTable $OtherDiagnosticsComorbidities
 */
class OtherDiagnosticsComorbiditiesController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['OtherComorbidities', 'Diagnostics']
        ];
        $otherDiagnosticsComorbidities = $this->paginate($this->OtherDiagnosticsComorbidities);

        $this->set(compact('otherDiagnosticsComorbidities'));
        $this->set('_serialize', ['otherDiagnosticsComorbidities']);
    }

    /**
     * View method
     *
     * @param string|null $id Other Diagnostics Comorbidity id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $otherDiagnosticsComorbidity = $this->OtherDiagnosticsComorbidities->get($id, [
            'contain' => ['OtherComorbidities', 'Diagnostics']
        ]);

        $this->set('otherDiagnosticsComorbidity', $otherDiagnosticsComorbidity);
        $this->set('_serialize', ['otherDiagnosticsComorbidity']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $otherDiagnosticsComorbidity = $this->OtherDiagnosticsComorbidities->newEntity();
        if ($this->request->is('post')) {
            $otherDiagnosticsComorbidity = $this->OtherDiagnosticsComorbidities->patchEntity($otherDiagnosticsComorbidity, $this->request->data);
            if ($this->OtherDiagnosticsComorbidities->save($otherDiagnosticsComorbidity)) {
                $this->Flash->success(__('The other diagnostics comorbidity has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The other diagnostics comorbidity could not be saved. Please, try again.'));
            }
        }
        $otherComorbidities = $this->OtherDiagnosticsComorbidities->OtherComorbidities->find('list', ['limit' => 200]);
        $diagnostics = $this->OtherDiagnosticsComorbidities->Diagnostics->find('list', ['limit' => 200]);
        $this->set(compact('otherDiagnosticsComorbidity', 'otherComorbidities', 'diagnostics'));
        $this->set('_serialize', ['otherDiagnosticsComorbidity']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Other Diagnostics Comorbidity id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $otherDiagnosticsComorbidity = $this->OtherDiagnosticsComorbidities->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $otherDiagnosticsComorbidity = $this->OtherDiagnosticsComorbidities->patchEntity($otherDiagnosticsComorbidity, $this->request->data);
            if ($this->OtherDiagnosticsComorbidities->save($otherDiagnosticsComorbidity)) {
                $this->Flash->success(__('The other diagnostics comorbidity has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The other diagnostics comorbidity could not be saved. Please, try again.'));
            }
        }
        $otherComorbidities = $this->OtherDiagnosticsComorbidities->OtherComorbidities->find('list', ['limit' => 200]);
        $diagnostics = $this->OtherDiagnosticsComorbidities->Diagnostics->find('list', ['limit' => 200]);
        $this->set(compact('otherDiagnosticsComorbidity', 'otherComorbidities', 'diagnostics'));
        $this->set('_serialize', ['otherDiagnosticsComorbidity']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Other Diagnostics Comorbidity id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $otherDiagnosticsComorbidity = $this->OtherDiagnosticsComorbidities->get($id);
        if ($this->OtherDiagnosticsComorbidities->delete($otherDiagnosticsComorbidity)) {
            $this->Flash->success(__('The other diagnostics comorbidity has been deleted.'));
        } else {
            $this->Flash->error(__('The other diagnostics comorbidity could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
