<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * HealthInsurancePlans Controller
 *
 * @property \App\Model\Table\HealthInsurancePlansTable $HealthInsurancePlans
 */
class HealthInsurancePlansController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Permission');
        $this->loadComponent('Upload');
        $this->set('title', 'Convênios');
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'HealthInsurancePlans', $action);

        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index($unit_id = 0)
    {
        $this->paginate = [
            'conditions' => ['unit_id =' => $unit_id],
            'contain'    => ['Units'],
        ];
        $healthInsurancePlans = $this->paginate($this->HealthInsurancePlans);

        $this->set('unit_id', $unit_id);
        $this->set(compact('healthInsurancePlans'));
        $this->set('_serialize', ['healthInsurancePlans']);
    }

    /**
     * View method
     *
     * @param string|null $id Health Insurance Plan id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($health_id = 0, $unit_id = 0)
    {
        $healthInsurancePlan = $this->HealthInsurancePlans->get($health_id, [
            'contain' => ['Units'],
        ]);

        $this->set('unit_id', $unit_id);
        $this->set('healthInsurancePlan', $healthInsurancePlan);
        $this->set('_serialize', ['healthInsurancePlan']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add($unit_id = 0)
    {
        $healthInsurancePlan = $this->HealthInsurancePlans->newEntity();
        if ($this->request->is('post')) {
            $healthInsurancePlan = $this->HealthInsurancePlans->patchEntity($healthInsurancePlan, $this->request->data);
            if ($this->HealthInsurancePlans->save($healthInsurancePlan)) {
                $this->Flash->success(__('The health insurance plan has been saved.'));
                return $this->redirect(['action' => 'index', $unit_id]);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $units = $this->HealthInsurancePlans->Units->find('list', ['limit' => 200]);
        $this->set('unit_id', $unit_id);
        $this->set(compact('healthInsurancePlan', 'units'));
        $this->set('_serialize', ['healthInsurancePlan']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Health Insurance Plan id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($health_id = 0, $unit_id = 0)
    {
        $healthInsurancePlan = $this->HealthInsurancePlans->get($health_id, [
            'contain' => [],
        ]);

        if ($this->request->is(['patch', 'post', 'put'])) {
            $healthInsurancePlan = $this->HealthInsurancePlans->patchEntity($healthInsurancePlan, $this->request->data);

            if ($this->HealthInsurancePlans->save($healthInsurancePlan)) {
                $this->Flash->success(__('O registro foi salvo com sucesso.'));
                return $this->redirect(['action' => 'index', $unit_id]);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }

        $units = $this->HealthInsurancePlans->Units->find('list', ['limit' => 200]);
        $this->set(compact('healthInsurancePlan', 'units', 'unit_id'));
        $this->set('_serialize', ['healthInsurancePlan']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Health Insurance Plan id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $healthInsurancePlan = $this->HealthInsurancePlans->get($id);
        if ($this->HealthInsurancePlans->delete($healthInsurancePlan)) {
            $this->Flash->success(__('O registro foi deletado com sucesso.'));
        } else {
            $this->Flash->error(__('O registro não pode ser deletado. Por favor, tente novamente.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
