<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Cultures Controller
 *
 * @property \App\Model\Table\CulturesTable $Cultures
 */
class CulturesController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Culturas');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'CribScores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $cultures = $this->paginate($this->Cultures);

        $this->set(compact('cultures'));
        $this->set('_serialize', ['cultures']);
    }

    /**
     * View method
     *
     * @param string|null $id Culture id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $culture = $this->Cultures->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('culture', $culture);
        $this->set('_serialize', ['culture']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $culture = $this->Cultures->newEntity();
        if ($this->request->is('post')) {
            $culture = $this->Cultures->patchEntity($culture, $this->request->data);
            if ($this->Cultures->save($culture)) {
                $this->Flash->success(__('O registro foi salvo'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O não pode ser salvo.'));
            }
        }
        $hospitalizations = $this->Cultures->Hospitalizations->find('list', ['limit' => 200]);
        $list_antibiotics = $this->Cultures->ListAntibiotics->find('list', ['limit' => 200, 'fields' => ['id', 'nome']]);

        $this->set(compact('culture', 'hospitalizations', 'list_antibiotics'));
        $this->set('_serialize', ['culture']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Culture id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $culture = $this->Cultures->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $culture = $this->Cultures->patchEntity($culture, $this->request->data);
            if ($this->Cultures->save($culture)) {
                $this->Flash->success(__('The culture has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The culture could not be saved. Please, try again.'));
            }
        }
        $list_antibiotics = $this->Cultures->ListAntibiotics->find('list', ['limit' => 200, 'fields' => ['id', 'nome']]);
        $hospitalizations = $this->Cultures->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('culture', 'hospitalizations', 'list_antibiotics'));
        $this->set('_serialize', ['culture']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Culture id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $culture = $this->Cultures->get($id);
        if ($this->Cultures->delete($culture)) {
            $this->Flash->success(__('The culture has been deleted.'));
        } else {
            $this->Flash->error(__('The culture could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
