<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * ChestPainProtocols Controller
 *
 * @property \App\Model\Table\ChestPainProtocolsTable $ChestPainProtocols
 */
class ChestPainProtocolsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Protocolod de Dor Toráxica');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $chestPainProtocols = $this->paginate($this->ChestPainProtocols);

        $this->set(compact('chestPainProtocols'));
        $this->set('_serialize', ['chestPainProtocols']);
    }

    /**
     * View method
     *
     * @param string|null $id Chest Pain Protocol id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $chestPainProtocol = $this->ChestPainProtocols->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('chestPainProtocol', $chestPainProtocol);
        $this->set('_serialize', ['chestPainProtocol']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $chestPainProtocol = $this->ChestPainProtocols->newEntity();
        if ($this->request->is('post')) {
            $chestPainProtocol = $this->ChestPainProtocols->patchEntity($chestPainProtocol, $this->request->data);
            if ($this->ChestPainProtocols->save($chestPainProtocol)) {
                $this->Flash->success(__('O registro foi salvo'));
                return $this->redirect(['controller' => 'SepseProtocols', 'action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo'));
            }
        }
        $hospitalizations = $this->ChestPainProtocols->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('chestPainProtocol', 'hospitalizations'));
        $this->set('_serialize', ['chestPainProtocol']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Chest Pain Protocol id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $chestPainProtocol = $this->ChestPainProtocols->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $chestPainProtocol = $this->ChestPainProtocols->patchEntity($chestPainProtocol, $this->request->data);
            if ($this->ChestPainProtocols->save($chestPainProtocol)) {
                $this->Flash->success(__('O registro foi salvo'));
                return $this->redirect(['controller' => 'SepseProtocols', 'action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo'));
            }
        }
        $hospitalizations = $this->ChestPainProtocols->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('chestPainProtocol', 'hospitalizations'));
        $this->set('_serialize', ['chestPainProtocol']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Chest Pain Protocol id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $chestPainProtocol = $this->ChestPainProtocols->get($id);
        if ($this->ChestPainProtocols->delete($chestPainProtocol)) {
            $this->Flash->success(__('O registro foi deletado'));
        } else {
            $this->Flash->error(__('O registro não foi deletado'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
