<?php
namespace App\Model\Table;

use App\Model\Entity\StrengthAssessmentScale;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * StrengthAssessmentScales Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class StrengthAssessmentScalesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('strength_assessment_scales');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->integer('abducao_do_ombro_d')
            ->allowEmpty('abducao_do_ombro_d');

        $validator
            ->integer('abducao_do_ombro_e')
            ->allowEmpty('abducao_do_ombro_e');

        $validator
            ->integer('flexao_do_cotovelo_d')
            ->allowEmpty('flexao_do_cotovelo_d');

        $validator
            ->integer('flexao_do_cotovelo_e')
            ->allowEmpty('flexao_do_cotovelo_e');

        $validator
            ->integer('extensao_do_punho_d')
            ->allowEmpty('extensao_do_punho_d');

        $validator
            ->integer('extensao_do_punho_e')
            ->allowEmpty('extensao_do_punho_e');

        $validator
            ->integer('dorsiflexao_do_tornozelo_e')
            ->allowEmpty('dorsiflexao_do_tornozelo_e');

        $validator
            ->integer('flexao_do_quadril_d')
            ->allowEmpty('flexao_do_quadril_d');

        $validator
            ->integer('flexao_do_quadril_e')
            ->allowEmpty('flexao_do_quadril_e');

        $validator
            ->integer('extensao_do_joelho_d')
            ->allowEmpty('extensao_do_joelho_d');

        $validator
            ->integer('extensao_do_joelho_e')
            ->allowEmpty('extensao_do_joelho_e');

        $validator
            ->integer('dorsiflexao_do_tornozelo_d')
            ->allowEmpty('dorsiflexao_do_tornozelo_d');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->integer('pontuation')
            ->allowEmpty('pontuation');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
