<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * MedicalBulletins Controller
 *
 * @property \App\Model\Table\MedicalBulletinsTable $MedicalBulletins
 */
class MedicalBulletinsController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Boletim Médico');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $medicalBulletins = $this->paginate($this->MedicalBulletins);

        $this->set(compact('medicalBulletins'));
        $this->set('_serialize', ['medicalBulletins']);
    }

    /**
     * View method
     *
     * @param string|null $id Medical Bulletin id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $medicalBulletin = $this->MedicalBulletins->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('medicalBulletin', $medicalBulletin);
        $this->set('_serialize', ['medicalBulletin']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $medicalBulletin = $this->MedicalBulletins->newEntity();
        if ($this->request->is('post')) {
            $medicalBulletin = $this->MedicalBulletins->patchEntity($medicalBulletin, $this->request->data);
            if ($this->MedicalBulletins->save($medicalBulletin)) {
                $this->Flash->success(__('O registro foi salvo com sucesso.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->MedicalBulletins->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('medicalBulletin', 'hospitalizations'));
        $this->set('_serialize', ['medicalBulletin']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Medical Bulletin id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $medicalBulletin = $this->MedicalBulletins->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $medicalBulletin = $this->MedicalBulletins->patchEntity($medicalBulletin, $this->request->data);
            if ($this->MedicalBulletins->save($medicalBulletin)) {
                $this->Flash->success(__('O registro foi salvo com sucesso.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->MedicalBulletins->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('medicalBulletin', 'hospitalizations'));
        $this->set('_serialize', ['medicalBulletin']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Medical Bulletin id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $medicalBulletin = $this->MedicalBulletins->get($id);
        if ($this->MedicalBulletins->delete($medicalBulletin)) {
            $this->Flash->success(__('O registro foi deletado.'));
        } else {
            $this->Flash->error(__('O registro não pode ser deletado. Por favor, tente novamente.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
