<?php
    $default_units_nav_bar = ROOT.DS.'src'.DS.'Template'.DS.'Element'.DS.'units-nav-bar.ctp';
    
    if (file_exists($default_units_nav_bar)) 
    {
        ob_start();
        include $default_units_nav_bar;
        echo ob_get_clean();
    }
    else 
    {
        echo $this->element('units-nav-bar');
    }
?>

<div class="signs index col-md-10 col-lg-10 columns content">
    <h3 class="big-title">Sinalizações</h3>
    <br>
    <?php    
        echo $this->Html->link('Nova Sinalização',
            ['controller' => 'Signs', 'action' => 'add', $unit_id]
            , array('class' => 'link-bt'));  
    ?>

    <br><br>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('Descrição') ?></th>
                <th><?= $this->Paginator->sort('Status') ?></th>
                <th class="actions"><?= __('Ações') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($signs as $sign): ?>
            <tr>
                <td><?= h($sign->description) ?></td>
                <td>
                    <?php
                         if ( h($sign->is_active) == 1)
                            {echo"Ativo";}
                        else
                            {echo "Suspenso";}
                     ?>
                </td>
                <td class="actions" style="white-space:nowrap">
                    <?php //echo $this->Html->link(__('Ver'), ['action' => 'view', $sign->id, $unit_id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Editar'), ['action' => 'edit', $sign->id, $unit_id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Deletar'), ['action' => 'delete', $sign->id, $unit_id], ['confirm' => __('Tem certeza que deseja desativar # {0}?', $sign->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('Anterior'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('Próximo') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
        </div>
    </center>
</div>