<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Obstetric Surgery Checklist']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="obstetricSurgeryChecklists index col-md-10 columns content">
    <h3>Obstetric Surgery Checklists</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('quais_equipamentos_medicamentos_adicionais_foram_necessarios') ?></th>
                <th><?= $this->Paginator->sort('algum_problema_ou_preocupacao_com_o_equipamento') ?></th>
                <th><?= $this->Paginator->sort('qual_o_nivel_de_urgencia') ?></th>
                <th><?= $this->Paginator->sort('paciente_requer_type_and_screen') ?></th>
                <th><?= $this->Paginator->sort('requer_type_and_screen_o_sangue_esta_disponivel') ?></th>
                <th><?= $this->Paginator->sort('paciente_precisa_de_um_ultrassom') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($obstetricSurgeryChecklists as $obstetricSurgeryChecklist): ?>
            <tr>
                <td><?= $this->Number->format($obstetricSurgeryChecklist->id) ?></td>
                <td><?= h($obstetricSurgeryChecklist->quais_equipamentos_medicamentos_adicionais_foram_necessarios) ?></td>
                <td><?= h($obstetricSurgeryChecklist->algum_problema_ou_preocupacao_com_o_equipamento) ?></td>
                <td><?= h($obstetricSurgeryChecklist->qual_o_nivel_de_urgencia) ?></td>
                <td><?= h($obstetricSurgeryChecklist->paciente_requer_type_and_screen) ?></td>
                <td><?= h($obstetricSurgeryChecklist->requer_type_and_screen_o_sangue_esta_disponivel) ?></td>
                <td><?= h($obstetricSurgeryChecklist->paciente_precisa_de_um_ultrassom) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?php //echo $this->Html->link(__('View'), ['action' => 'view', $obstetricSurgeryChecklist->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $obstetricSurgeryChecklist->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $obstetricSurgeryChecklist->id], ['confirm' => __('Are you sure you want to delete # {0}?', $obstetricSurgeryChecklist->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>