<nav class="col-lg-2 col-md-3">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a href=""><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('Edit {0}', ['Specialty']), ['action' => 'edit', $specialty->id]) ?> </li>
        <li><?= $this->Form->postLink(__('Delete {0}', ['Specialty']), ['action' => 'delete', $specialty->id], ['confirm' => __('Are you sure you want to delete # {0}?', $specialty->id)]) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Specialties']), ['action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Specialty']), ['action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Professionals']), ['controller' => 'Professionals', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Professional']), ['controller' => 'Professionals', 'action' => 'add']) ?> </li>
    </ul>
</nav>
<div class="specialties view col-lg-10 col-md-9">
    <h3><?= h($specialty->name) ?></h3>
    <table class="table table-striped table-hover">
        <tr>
            <th>Name</th>
            <td><?= h($specialty->name) ?></td>
        </tr>
        <tr>
            <th>'Id</th>
            <td><?= $this->Number->format($specialty->id) ?></td>
        </tr>
    </table>
    <div class="related">
        <h4><?= __('Related {0}', ['Professionals']) ?></h4>
        <?php if (!empty($specialty->professionals)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Cpf</th>
                <th>Telephone</th>
                <th>User Id</th>
                <th>Concil Number</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($specialty->professionals as $professionals): ?>
            <tr>
                <td><?= h($professionals->id) ?></td>
                <td><?= h($professionals->cpf) ?></td>
                <td><?= h($professionals->telephone) ?></td>
                <td><?= h($professionals->user_id) ?></td>
                <td><?= h($professionals->concil_number) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'Professionals', 'action' => 'view', $professionals->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'Professionals', 'action' => 'edit', $professionals->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'Professionals', 'action' => 'delete', $professionals->id], ['confirm' => __('Are you sure you want to delete # {0}?', $professionals->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
</div>
