<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Responsibles Telephone']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Responsibles']), ['controller' => 'Responsibles', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Responsible']), ['controller' => 'Responsibles', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Telephones']), ['controller' => 'Telephones', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Telephone']), ['controller' => 'Telephones', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="responsiblesTelephones index col-md-10 columns content">
    <h3>Responsibles Telephones</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('responsible_id') ?></th>
                <th><?= $this->Paginator->sort('telephone_id') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($responsiblesTelephones as $responsiblesTelephone): ?>
            <tr>
                <td><?= $this->Number->format($responsiblesTelephone->id) ?></td>
                <td><?= $responsiblesTelephone->has('responsible') ? $this->Html->link($responsiblesTelephone->responsible->name, ['controller' => 'Responsibles', 'action' => 'view', $responsiblesTelephone->responsible->id]) : '' ?></td>
                <td><?= $responsiblesTelephone->has('telephone') ? $this->Html->link($responsiblesTelephone->telephone->id, ['controller' => 'Telephones', 'action' => 'view', $responsiblesTelephone->telephone->id]) : '' ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $responsiblesTelephone->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $responsiblesTelephone->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $responsiblesTelephone->id], ['confirm' => __('Are you sure you want to delete # {0}?', $responsiblesTelephone->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>