<?php
namespace App\Model\Table;

use App\Model\Entity\ResponsiblesTelephone;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ResponsiblesTelephones Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Responsibles
 * @property \Cake\ORM\Association\BelongsTo $Telephones
 */
class ResponsiblesTelephonesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('responsibles_telephones');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Responsibles', [
            'foreignKey' => 'responsible_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Telephones', [
            'foreignKey' => 'telephone_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['responsible_id'], 'Responsibles'));
        $rules->add($rules->existsIn(['telephone_id'], 'Telephones'));
        return $rules;
    }
}
