<?php
namespace App\Model\Table;

use App\Model\Entity\Sector;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Sectors Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Units
 * @property \Cake\ORM\Association\BelongsTo $Types
 * @property \Cake\ORM\Association\HasMany $IndicatorsSectors
 * @property \Cake\ORM\Association\HasMany $ProfessionalSectors
 * @property \Cake\ORM\Association\HasMany $Rooms
 */
class SectorsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('sectors');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Units', [
            'foreignKey' => 'unit_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Types', [
            'foreignKey' => 'type_id',
            'joinType' => 'INNER'
        ]);
        $this->hasMany('IndicatorsSectors', [
            'foreignKey' => 'sector_id'
        ]);
        $this->hasMany('ProfessionalSectors', [
            'foreignKey' => 'sector_id'
        ]);
        $this->hasMany('Rooms', [
            'foreignKey' => 'sector_id'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('tempo_de_descontaminacao_da_sala_cirurgica');

        $validator
            ->allowEmpty('tempo_de_descontaminacao_de_leito_da_UTI');

        $validator
            ->allowEmpty('tempo_de_descontaminacao_da_sala_cirurgica_contaminada');

        $validator
            ->allowEmpty('tempo_de_descontaminacao_de_leito_da_unidade_de_internacao');

        $validator
            ->allowEmpty('termo_de_consentimento_informado');

        $validator
            ->allowEmpty('modelo_de_boletim_medico_file');

        $validator
            ->allowEmpty('modelo_de_relatorio_medico_padrao_file');

        $validator
            ->allowEmpty('modelo_de_descricaoo_de_informacao_do_paciente_file');

        $validator
            ->integer('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['unit_id'], 'Units'));
        $rules->add($rules->existsIn(['type_id'], 'Types'));
        return $rules;
    }
}
