<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;

/**
 * Patients Controller
 *
 * @property \App\Model\Table\PatientsTable $Patients
 */
class PatientsController extends AppController
{

    public function initialize()
    {
        parent::initialize();

        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Paciente');
    }

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);

        $this->Auth->allow(['add', 'logout', 'recuperateEmail', 'delete']);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'patients', $action);

        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        // $patients = $this->paginate($this->Patients);

        // $this->set(compact('patients'));
        // $this->set('_serialize', ['patients']);
        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');

        $unitsTable = TableRegistry::get('Units');

        $param = $this->request;
        $name  = null;
        $cpf   = null;

        if (isset($param->query['name']) || isset($param->query['cpf'])) {
            $name = $param->query['name'];
            $cpf  = $param->query['cpf'];

            $query = $this->Patients->find()
                ->where(['Patients.document_number LIKE' => $cpf . '%', 'Patients.nome LIKE ' => $name . '%'])
                ->contain(['Units'])
            ;
            $query->innerJoinWith('Units')
                ->distinct(['Patients.id'])
                ->where(['Units.id =' => $unit_id])
            ;
        } else {
            $query = $this->Patients->find()
                ->contain(['Units'])
            ;

            $query->innerJoinWith('Units')
                ->distinct(['Patients.id'])
                ->where(['Units.id =' => $unit_id])
            ;
        }

        // $users = $this->paginate($this->Users);
        $patients = $this->paginate($query);

        $this->set(compact('patients'));
        $this->set('_serialize', ['patients']);
    }

    /**
     * View method
     *
     * @param string|null $id Patient id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $patient = $this->Patients->get($id, [
            //'contain' => ['Telephones', 'Allergies', 'Diagnostics', 'GlasgowComaScales', 'Hospitalizations', 'Responsibles', 'Screenings']
            //'contain' => ['Telephones'],
        ]);

        $this->set('patient', $patient);
        $this->set('_serialize', ['patient']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');
        $patient = $this->Patients->newEntity();

        $health_insurance_plans_table = TableRegistry::get('HealthInsurancePlans');
        $health_insurance_plans       = $health_insurance_plans_table
            ->find()
            ->where(['HealthInsurancePlans.unit_id =' => $unit_id])
            ->toArray()
        ;

        if ($this->request->is('post')) {
            $patient = $this->Patients->patchEntity($patient, $this->request->data);

            if ($this->Patients->save($patient)) {
                $this->Flash->success(__('O paciente foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O paciente não pode ser salvo. Por favor, tente novamente.'));
            }
        }

        //$telephones = $this->Patients->Telephones->find('list', ['limit' => 200]);
        $this->set(compact('patient', "unit_id", 'health_insurance_plans'));
        $this->set('_serialize', ['patient']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Patient id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $patient = $this->Patients->get($id, [
            // 'contain' => ['Telephones'],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $patient = $this->Patients->patchEntity($patient, $this->request->data);
            if ($this->Patients->save($patient)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O paciente não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        //$telephones = $this->Patients->Telephones->find('list', ['limit' => 200]);
        $this->set(compact('patient'));
        $this->set('_serialize', ['patient']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Patient id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $patient = $this->Patients->get($id);
        if ($this->Patients->delete($patient)) {
            $this->Flash->success(__('O paciente foi deletado.'));
        } else {
            $this->Flash->error(__('O paciente não pode ser deletado.'));
        }
        return $this->redirect(['action' => 'index']);
    }

    //lista os pacientes da unidade
    public function listPatientsFromUnit()
    {
        $session = $this->request->session();
        $unit_id = $session->read('selected-unit');

        $unitsTable = TableRegistry::get('Units');

        $query = $this->Patients->find()
            ->contain(['Units'])
        ;

        $query->innerJoinWith('Units')
            ->distinct(['Patients.id'])
            ->where(['Units.id =' => $unit_id])
        ;

        // $users = $this->paginate($this->Users);
        $patients = $this->paginate($query);

        $this->set(compact('patients'));
        $this->set('_serialize', ['patients']);
    }

    //guarda o id do pacienta na session e redireciona pra pagina de internacao
    public function selectPatient($patient_id = null, $patient_name = null, $data_internacao = null)
    {
        if ($patient_id !== null) {
            $session = $this->request->session();
            $session->write('selected-pacient', $patient_id);
            $session->write('selected-patient-name', $patient_name);
            $session->write('selected-patient-name', $patient_name);
            $session->write('selected-hospitalization-date', date($data_internacao));

            return $this->redirect(['controller' => 'hospitalizations', 'action' => 'index']);
        }
    }
}
