<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * ObstetricSurgeryChecklists Controller
 *
 * @property \App\Model\Table\ObstetricSurgeryChecklistsTable $ObstetricSurgeryChecklists
 */
class ObstetricSurgeryChecklistsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations']
        ];
        $obstetricSurgeryChecklists = $this->paginate($this->ObstetricSurgeryChecklists);

        $this->set(compact('obstetricSurgeryChecklists'));
        $this->set('_serialize', ['obstetricSurgeryChecklists']);
    }

    /**
     * View method
     *
     * @param string|null $id Obstetric Surgery Checklist id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $obstetricSurgeryChecklist = $this->ObstetricSurgeryChecklists->get($id, [
            'contain' => ['Hospitalizations']
        ]);

        $this->set('obstetricSurgeryChecklist', $obstetricSurgeryChecklist);
        $this->set('_serialize', ['obstetricSurgeryChecklist']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $obstetricSurgeryChecklist = $this->ObstetricSurgeryChecklists->newEntity();
        if ($this->request->is('post')) {
            $obstetricSurgeryChecklist = $this->ObstetricSurgeryChecklists->patchEntity($obstetricSurgeryChecklist, $this->request->data);
            if ($this->ObstetricSurgeryChecklists->save($obstetricSurgeryChecklist)) {
                $this->Flash->success(__('The obstetric surgery checklist has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The obstetric surgery checklist could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->ObstetricSurgeryChecklists->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('obstetricSurgeryChecklist', 'hospitalizations'));
        $this->set('_serialize', ['obstetricSurgeryChecklist']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Obstetric Surgery Checklist id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $obstetricSurgeryChecklist = $this->ObstetricSurgeryChecklists->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $obstetricSurgeryChecklist = $this->ObstetricSurgeryChecklists->patchEntity($obstetricSurgeryChecklist, $this->request->data);
            if ($this->ObstetricSurgeryChecklists->save($obstetricSurgeryChecklist)) {
                $this->Flash->success(__('The obstetric surgery checklist has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The obstetric surgery checklist could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->ObstetricSurgeryChecklists->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('obstetricSurgeryChecklist', 'hospitalizations'));
        $this->set('_serialize', ['obstetricSurgeryChecklist']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Obstetric Surgery Checklist id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $obstetricSurgeryChecklist = $this->ObstetricSurgeryChecklists->get($id);
        if ($this->ObstetricSurgeryChecklists->delete($obstetricSurgeryChecklist)) {
            $this->Flash->success(__('The obstetric surgery checklist has been deleted.'));
        } else {
            $this->Flash->error(__('The obstetric surgery checklist could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
