<?php $this->assign('title', $title); ?>

<div class="row">

<div class="patients index col-md-10 columns content">
    <h3>Pacientes</h3>
    <br>   
    <?php 
    //if ($isLogged['role_name'] == " ")    
        echo $this->Html->link('Novo Paciente',
            ['controller' => 'Patients', 'action' => 'add']
            , array('class' => 'link-bt'));  
    ?>
    <br><br> 
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('nome') ?></th>
                <th><?= $this->Paginator->sort('email') ?></th>
                <th><?= $this->Paginator->sort('document_number') ?></th>
                <th><?= $this->Paginator->sort('birthday') ?></th>
                <th><?= $this->Paginator->sort('nationality') ?></th>
                <th><?= $this->Paginator->sort('profession') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($patients as $patient): ?>
            <tr>
                <td><?= $this->Number->format($patient->id) ?></td>
                <td><?= h($patient->nome) ?></td>
                <td><?= h($patient->email) ?></td>
                <td><?= h($patient->document_number) ?></td>
                <td><?= h($patient->birthday) ?></td>
                <td><?= h($patient->nationality) ?></td>
                <td><?= h($patient->profession) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $patient->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $patient->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $patient->id], ['confirm' => __('Are you sure you want to delete # {0}?', $patient->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
           
        </div>
    </center>
</div>
</div>