<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Measure']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Supportive Measures']), ['controller' => 'SupportiveMeasures', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Supportive Measure']), ['controller' => 'SupportiveMeasures', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="measures index col-md-10 columns content">
    <h3>Measures</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('data_insercao') ?></th>
                <th><?= $this->Paginator->sort('previsao_retirada') ?></th>
                <th><?= $this->Paginator->sort('description') ?></th>
                <th><?= $this->Paginator->sort('type') ?></th>
                <th><?= $this->Paginator->sort('supportive_measure_id') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($measures as $measure): ?>
            <tr>
                <td><?= $this->Number->format($measure->id) ?></td>
                <td><?= h($measure->data_insercao) ?></td>
                <td><?= h($measure->previsao_retirada) ?></td>
                <td><?= h($measure->description) ?></td>
                <td><?= h($measure->type) ?></td>
                <td><?= $measure->has('supportive_measure') ? $this->Html->link($measure->supportive_measure->id, ['controller' => 'SupportiveMeasures', 'action' => 'view', $measure->supportive_measure->id]) : '' ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $measure->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $measure->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $measure->id], ['confirm' => __('Are you sure you want to delete # {0}?', $measure->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>