<?php
namespace App\Model\Table;

use App\Model\Entity\NasScore;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * NasScores Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class NasScoresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('nas_scores');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType'   => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('monitoramento_e_controles');

        $validator
            ->allowEmpty('investigacoes_laboratoriais');

        $validator
            ->allowEmpty('medicacao');

        $validator
            ->allowEmpty('procedimentos_de_higiene');

        $validator
            ->allowEmpty('cuidados_com_drenos');

        $validator
            ->allowEmpty('mobilizacao_e_posicionamento');

        $validator
            ->allowEmpty('suporte_e_cuidados_aos_familiares');

        $validator
            ->allowEmpty('tarefas_administrativas');

        $validator
            ->allowEmpty('suporte_ventilatorio');

        $validator
            ->allowEmpty('cuidado_com_vias_aereas');

        $validator
            ->allowEmpty('tratamento_para_funcao_pulmonar');

        $validator
            ->allowEmpty('medicacao_vasoativa');

        $validator
            ->allowEmpty('reposicao_iv_de_grandes_perdas_de_fluidos');

        $validator
            ->allowEmpty('monitoracao_com_cateter_de_swan_ganz');

        $validator
            ->allowEmpty('rcp_nas_ultimas_24h');

        $validator
            ->allowEmpty('tecnicas_de_suporte_renal');

        $validator
            ->allowEmpty('medida_do_debito_urinario');

        $validator
            ->allowEmpty('medida_da_pic');

        $validator
            ->allowEmpty('tratamento_da_acidose');

        $validator
            ->allowEmpty('nutricao_parenteral_total');

        $validator
            ->allowEmpty('nutricao_enteral');

        $validator
            ->allowEmpty('intervencoes_especificas_na_uti');

        $validator
            ->allowEmpty('intervencoes_especificas_fora_da_uti');

        $validator
        //->date('data_de_realizacao')
        ->requirePresence('data_de_realizacao', 'create')
            ->notEmpty('data_de_realizacao');

        $validator
            ->allowEmpty('doenca_do_paciente');

        $validator
            ->boolean('active')
            ->allowEmpty('active');

        $validator
            ->allowEmpty('pontuacao');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
