<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * SurgicalChecklist Entity.
 *
 * @property int $id
 * @property bool $checar_dois_identificadores_do_paciente
 * @property bool $anexar_impresso_checklist_de_recepcao_de_orgao
 * @property bool $anamnese_e_exame_fisico
 * @property bool $algoritmo_tromboembolismo_venoso
 * @property bool $avaliacao_pre_anestesica
 * @property bool $consentimento_cirurgico_sitio_lateralidade
 * @property bool $sitio_demarcado
 * @property bool $conferencia_paciente_agendamento
 * @property bool $checar_identificadores_do_paciente
 * @property bool $atb_profilatico_60_minutos_antes_da_incisao_cirurgica
 * @property \Cake\I18n\Time $atb_horario
 * @property bool $atb_terapeutico
 * @property bool $materiais_implantes_estao_funcionando_e_disponiveis
 * @property bool $equipamentos_checados_pela_engenharia_clinica
 * @property bool $consentimento_anestesico
 * @property bool $consentimento_cirurgico_com_lateralidade_se_aplicavel
 * @property bool $laringoscopio
 * @property bool $kts_ambu
 * @property bool $Aspirador
 * @property bool $seringas_identificadoras
 * @property bool $monitor_oximetro_de_pylso_no_paciente_e_funcionando
 * @property bool $via_aerea_dificil
 * @property bool $equipamento_vad_disponivel
 * @property bool $alergia
 * @property bool $profilaxia_para_tev
 * @property bool $meias_elasticas
 * @property bool $massageador_intermitente
 * @property bool $profilaxia_medicamentosa
 * @property bool $esperado_perda_sanguinea
 * @property bool $acesso_venoso_central
 * @property bool $dois_acessos_disponiveis
 * @property bool $confirmacao_paciente_cirurgia_a_ser_realizado
 * @property bool $checagem_da_equipe_que_esta_em_saia
 * @property bool $todos_os_materais_uncionando_e_disponiveis
 * @property bool $atb_profilático_realizado
 * @property bool $exames_de_imagens_e_laboratoriais_essenciais_em_saia
 * @property bool $necessidades_de_congelacao_patologista
 * @property bool $informacoes_do_paciente_foram_confirmadas
 * @property bool $consentimentos_cirurgico_anestesico_foi_assinado
 * @property bool $visualizacao_o_local_da_cirurgica_marcado_nao_aplicavel
 * @property bool $checklist_da_anestesia_foi_executado
 * @property bool $ficha_anestesica_esta_completa
 * @property bool $recursos_humanos_estao_disponiveis
 * @property bool $equipamentos_foram_verificados
 * @property bool $monitorizacao_standard_colocada_e_funcionante
 * @property bool $acesso_venoso_adequado
 * @property bool $alguma_alergia_conhecida
 * @property bool $via_aerea_difícil_risco_de_aspiracao
 * @property bool $flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo
 * @property bool $nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado
 * @property bool $cirurgiao_anestesista_e_enfermeiro_confirmaram_verbalmente
 * @property bool $procedimento_cirurgico_realizado
 * @property bool $contagem_correta_de_instrumentos
 * @property bool $pecas_anatomicas_produtos_para_analie_corretamente_identificados
 * @property bool $todos_revem_necessidades_pos_operatorias
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 * @property \Cake\I18n\Time $created
 */
class SurgicalChecklist extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
