<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Historic Of Localization']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Rooms']), ['controller' => 'Rooms', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Room']), ['controller' => 'Rooms', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="historicOfLocalizations index col-md-10 columns content">
    <h3>Historic Of Localizations</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('created') ?></th>
                <th><?= $this->Paginator->sort('hospitalization_id') ?></th>
                <th><?= $this->Paginator->sort('entry_date') ?></th>
                <th><?= $this->Paginator->sort('exit_date') ?></th>
                <th><?= $this->Paginator->sort('room_id') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($historicOfLocalizations as $historicOfLocalization): ?>
            <tr>
                <td><?= $this->Number->format($historicOfLocalization->id) ?></td>
                <td><?= h($historicOfLocalization->created) ?></td>
                <td><?= $historicOfLocalization->has('hospitalization') ? $this->Html->link($historicOfLocalization->hospitalization->id, ['controller' => 'Hospitalizations', 'action' => 'view', $historicOfLocalization->hospitalization->id]) : '' ?></td>
                <td><?= h($historicOfLocalization->entry_date) ?></td>
                <td><?= h($historicOfLocalization->exit_date) ?></td>
                <td><?= $historicOfLocalization->has('room') ? $this->Html->link($historicOfLocalization->room->id, ['controller' => 'Rooms', 'action' => 'view', $historicOfLocalization->room->id]) : '' ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $historicOfLocalization->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $historicOfLocalization->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $historicOfLocalization->id], ['confirm' => __('Are you sure you want to delete # {0}?', $historicOfLocalization->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>