<?php
namespace App\Model\Table;

use App\Model\Entity\SurgicalChecklist;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SurgicalChecklists Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class SurgicalChecklistsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('surgical_checklists');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('checar_dois_identificadores_do_paciente')
            ->allowEmpty('checar_dois_identificadores_do_paciente');

        $validator
            ->boolean('anexar_impresso_checklist_de_recepcao_de_orgao')
            ->allowEmpty('anexar_impresso_checklist_de_recepcao_de_orgao');

        $validator
            ->boolean('anamnese_e_exame_fisico')
            ->allowEmpty('anamnese_e_exame_fisico');

        $validator
            ->boolean('algoritmo_tromboembolismo_venoso')
            ->allowEmpty('algoritmo_tromboembolismo_venoso');

        $validator
            ->boolean('avaliacao_pre_anestesica')
            ->allowEmpty('avaliacao_pre_anestesica');

        $validator
            ->boolean('consentimento_cirurgico_sitio_lateralidade')
            ->allowEmpty('consentimento_cirurgico_sitio_lateralidade');

        $validator
            ->boolean('sitio_demarcado')
            ->allowEmpty('sitio_demarcado');

        $validator
            ->boolean('conferencia_paciente_agendamento')
            ->allowEmpty('conferencia_paciente_agendamento');

        $validator
            ->boolean('checar_identificadores_do_paciente')
            ->allowEmpty('checar_identificadores_do_paciente');

        $validator
            ->boolean('atb_profilatico_60_minutos_antes_da_incisao_cirurgica')
            ->allowEmpty('atb_profilatico_60_minutos_antes_da_incisao_cirurgica');

        $validator
            ->time('atb_horario')
            ->allowEmpty('atb_horario');

        $validator
            ->boolean('atb_terapeutico')
            ->allowEmpty('atb_terapeutico');

        $validator
            ->boolean('materiais_implantes_estao_funcionando_e_disponiveis')
            ->allowEmpty('materiais_implantes_estao_funcionando_e_disponiveis');

        $validator
            ->boolean('equipamentos_checados_pela_engenharia_clinica')
            ->allowEmpty('equipamentos_checados_pela_engenharia_clinica');

        $validator
            ->boolean('consentimento_anestesico')
            ->allowEmpty('consentimento_anestesico');

        $validator
            ->boolean('consentimento_cirurgico_com_lateralidade_se_aplicavel')
            ->allowEmpty('consentimento_cirurgico_com_lateralidade_se_aplicavel');

        $validator
            ->boolean('laringoscopio')
            ->allowEmpty('laringoscopio');

        $validator
            ->boolean('kts_ambu')
            ->allowEmpty('kts_ambu');

        $validator
            ->boolean('Aspirador')
            ->allowEmpty('Aspirador');

        $validator
            ->boolean('seringas_identificadoras')
            ->allowEmpty('seringas_identificadoras');

        $validator
            ->boolean('monitor_oximetro_de_pylso_no_paciente_e_funcionando')
            ->allowEmpty('monitor_oximetro_de_pylso_no_paciente_e_funcionando');

        $validator
            ->boolean('via_aerea_dificil')
            ->allowEmpty('via_aerea_dificil');

        $validator
            ->boolean('equipamento_vad_disponivel')
            ->allowEmpty('equipamento_vad_disponivel');

        $validator
            ->boolean('alergia')
            ->allowEmpty('alergia');

        $validator
            ->boolean('profilaxia_para_tev')
            ->allowEmpty('profilaxia_para_tev');

        $validator
            ->boolean('meias_elasticas')
            ->allowEmpty('meias_elasticas');

        $validator
            ->boolean('massageador_intermitente')
            ->allowEmpty('massageador_intermitente');

        $validator
            ->boolean('profilaxia_medicamentosa')
            ->allowEmpty('profilaxia_medicamentosa');

        $validator
            ->boolean('esperado_perda_sanguinea')
            ->allowEmpty('esperado_perda_sanguinea');

        $validator
            ->boolean('acesso_venoso_central')
            ->allowEmpty('acesso_venoso_central');

        $validator
            ->boolean('dois_acessos_disponiveis')
            ->allowEmpty('dois_acessos_disponiveis');

        $validator
            ->boolean('confirmacao_paciente_cirurgia_a_ser_realizado')
            ->allowEmpty('confirmacao_paciente_cirurgia_a_ser_realizado');

        $validator
            ->boolean('checagem_da_equipe_que_esta_em_saia')
            ->allowEmpty('checagem_da_equipe_que_esta_em_saia');

        $validator
            ->boolean('todos_os_materais_uncionando_e_disponiveis')
            ->allowEmpty('todos_os_materais_uncionando_e_disponiveis');

        $validator
            ->boolean('atb_profilático_realizado')
            ->allowEmpty('atb_profilático_realizado');

        $validator
            ->boolean('exames_de_imagens_e_laboratoriais_essenciais_em_saia')
            ->allowEmpty('exames_de_imagens_e_laboratoriais_essenciais_em_saia');

        $validator
            ->boolean('necessidades_de_congelacao_patologista')
            ->allowEmpty('necessidades_de_congelacao_patologista');

        $validator
            ->boolean('informacoes_do_paciente_foram_confirmadas')
            ->allowEmpty('informacoes_do_paciente_foram_confirmadas');

        $validator
            ->boolean('consentimentos_cirurgico_anestesico_foi_assinado')
            ->allowEmpty('consentimentos_cirurgico_anestesico_foi_assinado');

        $validator
            ->boolean('visualizacao_o_local_da_cirurgica_marcado_nao_aplicavel')
            ->allowEmpty('visualizacao_o_local_da_cirurgica_marcado_nao_aplicavel');

        $validator
            ->boolean('checklist_da_anestesia_foi_executado')
            ->allowEmpty('checklist_da_anestesia_foi_executado');

        $validator
            ->boolean('ficha_anestesica_esta_completa')
            ->allowEmpty('ficha_anestesica_esta_completa');

        $validator
            ->boolean('recursos_humanos_estao_disponiveis')
            ->allowEmpty('recursos_humanos_estao_disponiveis');

        $validator
            ->boolean('equipamentos_foram_verificados')
            ->allowEmpty('equipamentos_foram_verificados');

        $validator
            ->boolean('monitorizacao_standard_colocada_e_funcionante')
            ->allowEmpty('monitorizacao_standard_colocada_e_funcionante');

        $validator
            ->boolean('acesso_venoso_adequado')
            ->allowEmpty('acesso_venoso_adequado');

        $validator
            ->boolean('alguma_alergia_conhecida')
            ->allowEmpty('alguma_alergia_conhecida');

        $validator
            ->boolean('via_aerea_difícil_risco_de_aspiracao')
            ->allowEmpty('via_aerea_difícil_risco_de_aspiracao');

        $validator
            ->boolean('flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo')
            ->allowEmpty('flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo');

        $validator
            ->boolean('nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado')
            ->allowEmpty('nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado');

        $validator
            ->boolean('cirurgiao_anestesista_e_enfermeiro_confirmaram_verbalmente')
            ->allowEmpty('cirurgiao_anestesista_e_enfermeiro_confirmaram_verbalmente');

        $validator
            ->boolean('procedimento_cirurgico_realizado')
            ->allowEmpty('procedimento_cirurgico_realizado');

        $validator
            ->boolean('contagem_correta_de_instrumentos')
            ->allowEmpty('contagem_correta_de_instrumentos');

        $validator
            ->boolean('pecas_anatomicas_produtos_para_analie_corretamente_identificados')
            ->allowEmpty('pecas_anatomicas_produtos_para_analie_corretamente_identificados');

        $validator
            ->boolean('todos_revem_necessidades_pos_operatorias')
            ->allowEmpty('todos_revem_necessidades_pos_operatorias');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
