<?php
namespace App\Model\Table;

use App\Model\Entity\CribScore;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * CribScores Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class CribScoresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('crib_scores');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('peso_nascimento');

        $validator
            //->integer('idade_gestacional')
            ->allowEmpty('idade_gestacional');

        $validator
            ->allowEmpty('malfomacao_congenita');

        $validator
            ->allowEmpty('be_maximo_nas_primeiros_12h_de_vida');

        $validator
            ->allowEmpty('fio2_minima_apropriada_nas_primeiras_12h_de_vida');

        $validator
            ->allowEmpty('fio2_maxima_apropriada_nas_primeiras_12h_de_vida');

        $validator
            //->integer('pontuacao')
            ->allowEmpty('pontuacao');

        $validator
            ->boolean('active')
            ->allowEmpty('active');

        $validator
            //->date('data_realizacao')
            ->requirePresence('data_realizacao', 'create')
            ->notEmpty('data_realizacao');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
