<?php
namespace App\Model\Table;

use App\Model\Entity\CardiacSurgeryChecklist;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * CardiacSurgeryChecklists Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class CardiacSurgeryChecklistsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('cardiac_surgery_checklists');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType'   => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('as_informacoes_do_paciente_foram_confirmadas')
            ->allowEmpty('as_informacoes_do_paciente_foram_confirmadas');

        $validator
            ->boolean('o_consentimento_cirurgico_anestesico_foi_assinado')
            ->allowEmpty('o_consentimento_cirurgico_anestesico_foi_assinado');

        $validator
            ->boolean('visualizacao_do_local_da_cirurgica_marcado_nao_aplicavel')
            ->allowEmpty('visualizacao_do_local_da_cirurgica_marcado_nao_aplicavel');

        $validator
            ->boolean('o_checklist_da_anestesia_foi_executado')
            ->allowEmpty('o_checklist_da_anestesia_foi_executado');

        $validator
            ->boolean('a_ficha_anestesica_esta_completa')
            ->allowEmpty('a_ficha_anestesica_esta_completa');

        $validator
            ->boolean('os_recursos_humanos_estao_disponiveis')
            ->allowEmpty('os_recursos_humanos_estao_disponiveis');

        $validator
            ->boolean('os_equipamentos_foram_verificados')
            ->allowEmpty('os_equipamentos_foram_verificados');

        $validator
            ->boolean('monitorizacao_standard_colocada_e_funcionante')
            ->allowEmpty('monitorizacao_standard_colocada_e_funcionante');

        $validator
            ->boolean('acesso_venoso_adequado')
            ->allowEmpty('acesso_venoso_adequado');

        $validator
            ->boolean('alguma_alergia_conhecida')
            ->allowEmpty('alguma_alergia_conhecida');

        $validator
            ->boolean('via_aerea_dificil_risco_de_aspiracao')
            ->allowEmpty('via_aerea_dificil_risco_de_aspiracao');

        $validator
            ->boolean('flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo')
            ->allowEmpty('flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo');

        $validator
            ->boolean('nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado')
            ->allowEmpty('nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado');

        $validator
            ->boolean('cirurgiao_anestesista_e_enfermeiro_confirmaram')
            ->allowEmpty('cirurgiao_anestesista_e_enfermeiro_confirmaram');

        $validator
            ->boolean('procedimento_cirurgico_realizado')
            ->allowEmpty('procedimento_cirurgico_realizado');

        $validator
            ->boolean('contagem_correta_de_compressas')
            ->allowEmpty('contagem_correta_de_compressas');

        $validator
            ->boolean('pecas_anatomicas_e_produtos')
            ->allowEmpty('pecas_anatomicas_e_produtos');

        $validator
            ->boolean('necessidades_pos_operatorias_revistas')
            ->allowEmpty('necessidades_pos_operatorias_revistas');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
