<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * HistoricOfLocalizations Controller
 *
 * @property \App\Model\Table\HistoricOfLocalizationsTable $HistoricOfLocalizations
 */
class HistoricOfLocalizationsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations', 'Rooms']
        ];
        $historicOfLocalizations = $this->paginate($this->HistoricOfLocalizations);

        $this->set(compact('historicOfLocalizations'));
        $this->set('_serialize', ['historicOfLocalizations']);
    }

    /**
     * View method
     *
     * @param string|null $id Historic Of Localization id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $historicOfLocalization = $this->HistoricOfLocalizations->get($id, [
            'contain' => ['Hospitalizations', 'Rooms']
        ]);

        $this->set('historicOfLocalization', $historicOfLocalization);
        $this->set('_serialize', ['historicOfLocalization']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $historicOfLocalization = $this->HistoricOfLocalizations->newEntity();
        if ($this->request->is('post')) {
            $historicOfLocalization = $this->HistoricOfLocalizations->patchEntity($historicOfLocalization, $this->request->data);
            if ($this->HistoricOfLocalizations->save($historicOfLocalization)) {
                $this->Flash->success(__('The historic of localization has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The historic of localization could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->HistoricOfLocalizations->Hospitalizations->find('list', ['limit' => 200]);
        $rooms = $this->HistoricOfLocalizations->Rooms->find('list', ['limit' => 200]);
        $this->set(compact('historicOfLocalization', 'hospitalizations', 'rooms'));
        $this->set('_serialize', ['historicOfLocalization']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Historic Of Localization id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $historicOfLocalization = $this->HistoricOfLocalizations->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $historicOfLocalization = $this->HistoricOfLocalizations->patchEntity($historicOfLocalization, $this->request->data);
            if ($this->HistoricOfLocalizations->save($historicOfLocalization)) {
                $this->Flash->success(__('The historic of localization has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The historic of localization could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->HistoricOfLocalizations->Hospitalizations->find('list', ['limit' => 200]);
        $rooms = $this->HistoricOfLocalizations->Rooms->find('list', ['limit' => 200]);
        $this->set(compact('historicOfLocalization', 'hospitalizations', 'rooms'));
        $this->set('_serialize', ['historicOfLocalization']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Historic Of Localization id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $historicOfLocalization = $this->HistoricOfLocalizations->get($id);
        if ($this->HistoricOfLocalizations->delete($historicOfLocalization)) {
            $this->Flash->success(__('The historic of localization has been deleted.'));
        } else {
            $this->Flash->error(__('The historic of localization could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
