<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Cid10 Controller
 *
 * @property \App\Model\Table\Cid10Table $Cid10
 */
class Cid10Controller extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['DiagnosticGroups']
        ];
        $cid10 = $this->paginate($this->Cid10);

        $this->set(compact('cid10'));
        $this->set('_serialize', ['cid10']);
    }

    /**
     * View method
     *
     * @param string|null $id Cid10 id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $cid10 = $this->Cid10->get($id, [
            'contain' => ['DiagnosticGroups']
        ]);

        $this->set('cid10', $cid10);
        $this->set('_serialize', ['cid10']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $cid10 = $this->Cid10->newEntity();
        if ($this->request->is('post')) {
            $cid10 = $this->Cid10->patchEntity($cid10, $this->request->data);
            if ($this->Cid10->save($cid10)) {
                $this->Flash->success(__('The cid10 has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The cid10 could not be saved. Please, try again.'));
            }
        }
        $diagnosticGroups = $this->Cid10->DiagnosticGroups->find('list', ['limit' => 200]);
        $this->set(compact('cid10', 'diagnosticGroups'));
        $this->set('_serialize', ['cid10']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Cid10 id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $cid10 = $this->Cid10->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $cid10 = $this->Cid10->patchEntity($cid10, $this->request->data);
            if ($this->Cid10->save($cid10)) {
                $this->Flash->success(__('The cid10 has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The cid10 could not be saved. Please, try again.'));
            }
        }
        $diagnosticGroups = $this->Cid10->DiagnosticGroups->find('list', ['limit' => 200]);
        $this->set(compact('cid10', 'diagnosticGroups'));
        $this->set('_serialize', ['cid10']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Cid10 id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $cid10 = $this->Cid10->get($id);
        if ($this->Cid10->delete($cid10)) {
            $this->Flash->success(__('The cid10 has been deleted.'));
        } else {
            $this->Flash->error(__('The cid10 could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
