<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Origins Controller
 *
 * @property \App\Model\Table\OriginsTable $Origins
 */
class OriginsController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Permission');
        $this->loadComponent('Upload');
        $this->set('title', 'Origem');
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Origins', $action);

        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index($unit_id = 0)
    {
        $this->paginate = [
            'conditions' => ['unit_id =' => $unit_id],
            'contain'    => ['Units'],
        ];
        $origins = $this->paginate($this->Origins);

        $this->set('unit_id', $unit_id);
        $this->set(compact('origins'));
        $this->set('_serialize', ['origins']);
    }

    /**
     * View method
     *
     * @param string|null $id Origin id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($origin_id = 0, $unit_id = 0)
    {
        $origin = $this->Origins->get($origin_id, [
            'contain' => ['Units'],
        ]);

        $this->set('unit_id', $unit_id);
        $this->set('origin', $origin);
        $this->set('_serialize', ['origin']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add($unit_id = 0)
    {
        $origin = $this->Origins->newEntity();
        if ($this->request->is('post')) {
            $origin = $this->Origins->patchEntity($origin, $this->request->data);
            if ($this->Origins->save($origin)) {
                $this->Flash->success(__('A origem foi salva com sucesso.'));
                return $this->redirect(['action' => 'index', $unit_id]);
            } else {
                $this->Flash->error(__('A origem não pode ser salva. Por favor, tente novamente.'));
            }
        }
        $units = $this->Origins->Units->find('list', ['limit' => 200]);
        $this->set('unit_id', $unit_id);
        $this->set(compact('origin', 'units'));
        $this->set('_serialize', ['origin']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Origin id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($origin_id = 0, $unit_id = 0)
    {
        $origin = $this->Origins->get($origin_id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $origin = $this->Origins->patchEntity($origin, $this->request->data);

            if ($this->Origins->save($origin)) {
                $this->Flash->success(__('A origem foi salva com sucesso.'));
                return $this->redirect(['action' => 'index', $unit_id]);
            } else {
                $this->Flash->error(__('A origem não pode ser salva. Por favor, tente novamente.'));
            }
        }
        $units = $this->Origins->Units->find('list', ['limit' => 200]);
        $this->set(compact('origin', 'units', 'unit_id'));
        $this->set('_serialize', ['origin']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Origin id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $origin = $this->Origins->get($id);
        if ($this->Origins->delete($origin)) {
            $this->Flash->success(__('A origem foi deletada com sucesso.'));
        } else {
            $this->Flash->error(__('A origem não pode ser deletada. Por favor, tente novamente'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
