<?php
namespace App\Model\Table;

use App\Model\Entity\Screening;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Screenings Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Patients
 * @property \Cake\ORM\Association\BelongsTo $Units
 * @property \Cake\ORM\Association\HasMany $Bundles
 * @property \Cake\ORM\Association\HasMany $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $MedicalCares
 */
class ScreeningsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('screenings');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Patients', [
            'foreignKey' => 'patient_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Units', [
            'foreignKey' => 'unit_id',
            'joinType'   => 'INNER',
        ]);
        $this->hasMany('Bundles', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('PavPreventionBundles', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('Hospitalizations', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('MedicalCares', [
            'foreignKey' => 'screening_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('complaint', 'create')
            ->notEmpty('complaint');

        $validator
            ->allowEmpty('allergy');

        $validator
            ->allowEmpty('pre_existing_diseases');

        $validator
            ->requirePresence('height', 'create')
            ->notEmpty('height');

        $validator
            ->requirePresence('weight', 'create')
            ->notEmpty('weight');

        $validator
            ->allowEmpty('pulse');

        $validator
            ->allowEmpty('pa');

        $validator
            ->allowEmpty('respiration');

        $validator
            ->allowEmpty('temperature');

        $validator
            ->allowEmpty('saturation');

        $validator
            ->allowEmpty('capillary_glycemia');

        $validator
            ->allowEmpty('pain_intensity');

        $validator
            ->allowEmpty('pain_characteristics');

        $validator
            ->boolean('Electrocardiogram')
            ->allowEmpty('Electrocardiogram');

        $validator
            ->allowEmpty('appraiser_identification');

        $validator
            ->allowEmpty('nursing_notes');

        $validator
            ->allowEmpty('risk_rating');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['patient_id'], 'Patients'));
        $rules->add($rules->existsIn(['unit_id'], 'Units'));
        return $rules;
    }
}
