<?php
namespace App\Model\Table;

use App\Model\Entity\Medication;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Medications Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Signs
 * @property \Cake\ORM\Association\BelongsTo $Professionals
 * @property \Cake\ORM\Association\BelongsTo $Prescriptions
 * @property \Cake\ORM\Association\HasMany $Antibiotics
 * @property \Cake\ORM\Association\HasMany $MedicationsHistoric
 */
class MedicationsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('medications');
        $this->displayField('name');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Signs', [
            'foreignKey' => 'sign_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Professionals', [
            'foreignKey' => 'professional_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Prescriptions', [
            'foreignKey' => 'prescription_id',
            'joinType'   => 'INNER',
        ]);
        $this->hasMany('Antibiotics', [
            'foreignKey' => 'medication_id',
        ]);
        $this->hasMany('MedicationsHistoric', [
            'foreignKey' => 'medication_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('name');

        $validator
            ->allowEmpty('dosage');

        $validator
            ->allowEmpty('channel');

        $validator
            ->allowEmpty('frequency');

        $validator
            ->requirePresence('start_date', 'create')
            ->notEmpty('start_date');

        $validator
            ->requirePresence('end_date', 'create')
            ->notEmpty('end_date');

        $validator
            ->boolean('is_antibiotic')
            ->allowEmpty('is_antibiotic');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->boolean('cultura')
            ->allowEmpty('cultura');

        $validator
            ->allowEmpty('cultura_resultado');

        $validator
            ->allowEmpty('justificativa_antibiotico');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['sign_id'], 'Signs'));
        $rules->add($rules->existsIn(['professional_id'], 'Professionals'));
        $rules->add($rules->existsIn(['prescription_id'], 'Prescriptions'));
        return $rules;
    }
}
