<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Screenings Controller
 *
 * @property \App\Model\Table\ScreeningsTable $Screenings
 */
class ScreeningsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Triagem');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Patients', 'Units'],
        ];
        $screenings = $this->paginate($this->Screenings);

        $this->set(compact('screenings'));
        $this->set('_serialize', ['screenings']);
    }

    /**
     * View method
     *
     * @param string|null $id Screening id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $screening = $this->Screenings->get($id, [
            'contain' => ['Patients', 'Units', 'Bundles', 'Hospitalizations', 'MedicalCares'],
        ]);

        $this->set('screening', $screening);
        $this->set('_serialize', ['screening']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $screening = $this->Screenings->newEntity();
        if ($this->request->is('post')) {
            $screening = $this->Screenings->patchEntity($screening, $this->request->data);
            if ($this->Screenings->save($screening)) {
                $this->Flash->success(__('The screening has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The screening could not be saved. Please, try again.'));
            }
        }
        $patients = $this->Screenings->Patients->find('list', ['limit' => 200]);
        $units    = $this->Screenings->Units->find('list', ['limit' => 200]);
        $this->set(compact('screening', 'patients', 'units'));
        $this->set('_serialize', ['screening']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Screening id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $screening = $this->Screenings->get($id, [
            'contain' => [],
        ]);
        $session = $this->request->session();
        $session->write('screening_id', $id);

        if ($this->request->is(['patch', 'post', 'put'])) {
            $screening = $this->Screenings->patchEntity($screening, $this->request->data);
            if ($this->Screenings->save($screening)) {
                $this->Flash->success(__('The screening has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The screening could not be saved. Please, try again.'));
            }
        }

        $this->set('screening_id', $id);
        $patients = $this->Screenings->Patients->find('list', ['limit' => 200]);
        $units    = $this->Screenings->Units->find('list', ['limit' => 200]);
        $this->set(compact('screening', 'patients', 'units'));
        $this->set('_serialize', ['screening']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Screening id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $screening = $this->Screenings->get($id);
        if ($this->Screenings->delete($screening)) {
            $this->Flash->success(__('The screening has been deleted.'));
        } else {
            $this->Flash->error(__('The screening could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
