<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * OtherComorbidities Controller
 *
 * @property \App\Model\Table\OtherComorbiditiesTable $OtherComorbidities
 */
class OtherComorbiditiesController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $otherComorbidities = $this->paginate($this->OtherComorbidities);

        $this->set(compact('otherComorbidities'));
        $this->set('_serialize', ['otherComorbidities']);
    }

    /**
     * View method
     *
     * @param string|null $id Other Comorbidity id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $otherComorbidity = $this->OtherComorbidities->get($id, [
            'contain' => ['Diagnostics']
        ]);

        $this->set('otherComorbidity', $otherComorbidity);
        $this->set('_serialize', ['otherComorbidity']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $otherComorbidity = $this->OtherComorbidities->newEntity();
        if ($this->request->is('post')) {
            $otherComorbidity = $this->OtherComorbidities->patchEntity($otherComorbidity, $this->request->data);
            if ($this->OtherComorbidities->save($otherComorbidity)) {
                $this->Flash->success(__('The other comorbidity has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The other comorbidity could not be saved. Please, try again.'));
            }
        }
        $diagnostics = $this->OtherComorbidities->Diagnostics->find('list', ['limit' => 200]);
        $this->set(compact('otherComorbidity', 'diagnostics'));
        $this->set('_serialize', ['otherComorbidity']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Other Comorbidity id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $otherComorbidity = $this->OtherComorbidities->get($id, [
            'contain' => ['Diagnostics']
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $otherComorbidity = $this->OtherComorbidities->patchEntity($otherComorbidity, $this->request->data);
            if ($this->OtherComorbidities->save($otherComorbidity)) {
                $this->Flash->success(__('The other comorbidity has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The other comorbidity could not be saved. Please, try again.'));
            }
        }
        $diagnostics = $this->OtherComorbidities->Diagnostics->find('list', ['limit' => 200]);
        $this->set(compact('otherComorbidity', 'diagnostics'));
        $this->set('_serialize', ['otherComorbidity']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Other Comorbidity id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $otherComorbidity = $this->OtherComorbidities->get($id);
        if ($this->OtherComorbidities->delete($otherComorbidity)) {
            $this->Flash->success(__('The other comorbidity has been deleted.'));
        } else {
            $this->Flash->error(__('The other comorbidity could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
