<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Skin Integrity']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Fugulin Braden Scales']), ['controller' => 'FugulinBradenScales', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Fugulin Braden Scale']), ['controller' => 'FugulinBradenScales', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="skinIntegrities index col-md-10 columns content">
    <h3>Skin Integrities</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('lesao') ?></th>
                <th><?= $this->Paginator->sort('local') ?></th>
                <th><?= $this->Paginator->sort('data') ?></th>
                <th><?= $this->Paginator->sort('created') ?></th>
                <th><?= $this->Paginator->sort('is_active') ?></th>
                <th><?= $this->Paginator->sort('fugulin_braden_scale_id') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($skinIntegrities as $skinIntegrity): ?>
            <tr>
                <td><?= $this->Number->format($skinIntegrity->id) ?></td>
                <td><?= h($skinIntegrity->lesao) ?></td>
                <td><?= h($skinIntegrity->local) ?></td>
                <td><?= h($skinIntegrity->data) ?></td>
                <td><?= h($skinIntegrity->created) ?></td>
                <td><?= h($skinIntegrity->is_active) ?></td>
                <td><?= $skinIntegrity->has('fugulin_braden_scale') ? $this->Html->link($skinIntegrity->fugulin_braden_scale->id, ['controller' => 'FugulinBradenScales', 'action' => 'view', $skinIntegrity->fugulin_braden_scale->id]) : '' ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $skinIntegrity->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $skinIntegrity->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $skinIntegrity->id], ['confirm' => __('Are you sure you want to delete # {0}?', $skinIntegrity->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>