<nav class="col-lg-2 col-md-3">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a href=""><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('Edit {0}', ['Admission']), ['action' => 'edit', $admission->id]) ?> </li>
        <li><?= $this->Form->postLink(__('Delete {0}', ['Admission']), ['action' => 'delete', $admission->id], ['confirm' => __('Are you sure you want to delete # {0}?', $admission->id)]) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Admissions']), ['action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Admission']), ['action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Screenings']), ['controller' => 'Screenings', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Screening']), ['controller' => 'Screenings', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Habitual Medications']), ['controller' => 'HabitualMedications', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Habitual Medication']), ['controller' => 'HabitualMedications', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Hpps']), ['controller' => 'Hpps', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Hpp']), ['controller' => 'Hpps', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Physical Exams']), ['controller' => 'PhysicalExams', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Physical Exam']), ['controller' => 'PhysicalExams', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Relevant Complementary Exams']), ['controller' => 'RelevantComplementaryExams', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Relevant Complementary Exam']), ['controller' => 'RelevantComplementaryExams', 'action' => 'add']) ?> </li>
    </ul>
</nav>
<div class="admissions view col-lg-10 col-md-9">
    <h3><?= h($admission->id) ?></h3>
    <table class="table table-striped table-hover">
        <tr>
            <th>Motivo</th>
            <td><?= h($admission->motivo) ?></td>
        </tr>
        <tr>
            <th>Hda</th>
            <td><?= h($admission->hda) ?></td>
        </tr>
        <tr>
            <th>Int Hb</th>
            <td><?= h($admission->int_hb) ?></td>
        </tr>
        <tr>
            <th>Int Cti</th>
            <td><?= h($admission->int_cti) ?></td>
        </tr>
        <tr>
            <th>Equipe Assistente</th>
            <td><?= h($admission->equipe_assistente) ?></td>
        </tr>
        <tr>
            <th>Alergias</th>
            <td><?= h($admission->alergias) ?></td>
        </tr>
        <tr>
            <th>Motivo Hda</th>
            <td><?= h($admission->motivo_hda) ?></td>
        </tr>
        <tr>
            <th>Outras Patologia</th>
            <td><?= h($admission->outras_patologia) ?></td>
        </tr>
        <tr>
            <th>Screening</th>
            <td><?= $admission->has('screening') ? $this->Html->link($admission->screening->id, ['controller' => 'Screenings', 'action' => 'view', $admission->screening->id]) : '' ?></td>
        </tr>
        <tr>
            <th>Status</th>
            <td><?= h($admission->status) ?></td>
        </tr>
        <tr>
            <th>'Id</th>
            <td><?= $this->Number->format($admission->id) ?></td>
        </tr>
        <tr>
            <th>Created</th>
            <td><?= h($admission->created) ?></tr>
        </tr>
        <tr>
            <th>Isolamento</th>
            <td><?= $admission->isolamento ? __('Yes') : __('No'); ?></td>
         </tr>
    </table>
    <div class="related">
        <h4><?= __('Related {0}', ['Habitual Medications']) ?></h4>
        <?php if (!empty($admission->habitual_medications)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Droga</th>
                <th>Apresent</th>
                <th>Dose</th>
                <th>Intervalo</th>
                <th>Mantido</th>
                <th>Motivo De Nao Estar Mantido</th>
                <th>Admission Id</th>
                <th>Created</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($admission->habitual_medications as $habitualMedications): ?>
            <tr>
                <td><?= h($habitualMedications->id) ?></td>
                <td><?= h($habitualMedications->droga) ?></td>
                <td><?= h($habitualMedications->apresent) ?></td>
                <td><?= h($habitualMedications->dose) ?></td>
                <td><?= h($habitualMedications->intervalo) ?></td>
                <td><?= h($habitualMedications->mantido) ?></td>
                <td><?= h($habitualMedications->motivo_de_nao_estar_mantido) ?></td>
                <td><?= h($habitualMedications->admission_id) ?></td>
                <td><?= h($habitualMedications->created) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'HabitualMedications', 'action' => 'view', $habitualMedications->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'HabitualMedications', 'action' => 'edit', $habitualMedications->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'HabitualMedications', 'action' => 'delete', $habitualMedications->id], ['confirm' => __('Are you sure you want to delete # {0}?', $habitualMedications->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
    <div class="related">
        <h4><?= __('Related {0}', ['Hpps']) ?></h4>
        <?php if (!empty($admission->hpps)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Nome</th>
                <th>Admission Id</th>
                <th>Created</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($admission->hpps as $hpps): ?>
            <tr>
                <td><?= h($hpps->id) ?></td>
                <td><?= h($hpps->nome) ?></td>
                <td><?= h($hpps->admission_id) ?></td>
                <td><?= h($hpps->created) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'Hpps', 'action' => 'view', $hpps->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'Hpps', 'action' => 'edit', $hpps->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'Hpps', 'action' => 'delete', $hpps->id], ['confirm' => __('Are you sure you want to delete # {0}?', $hpps->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
    <div class="related">
        <h4><?= __('Related {0}', ['Physical Exams']) ?></h4>
        <?php if (!empty($admission->physical_exams)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Pa</th>
                <th>Fr</th>
                <th>Ectoscopia</th>
                <th>Acv</th>
                <th>Abd</th>
                <th>Mmii</th>
                <th>Neuro</th>
                <th>Acessos</th>
                <th>Irpm</th>
                <th>Kg</th>
                <th>Mmhg</th>
                <th>So2</th>
                <th>Alt</th>
                <th>Fc</th>
                <th>So2 Percent</th>
                <th>So2 Tax</th>
                <th>So2 Temp</th>
                <th>Alt M</th>
                <th>Alt Imc</th>
                <th>Created</th>
                <th>Admission Id</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($admission->physical_exams as $physicalExams): ?>
            <tr>
                <td><?= h($physicalExams->id) ?></td>
                <td><?= h($physicalExams->pa) ?></td>
                <td><?= h($physicalExams->fr) ?></td>
                <td><?= h($physicalExams->ectoscopia) ?></td>
                <td><?= h($physicalExams->acv) ?></td>
                <td><?= h($physicalExams->abd) ?></td>
                <td><?= h($physicalExams->mmii) ?></td>
                <td><?= h($physicalExams->neuro) ?></td>
                <td><?= h($physicalExams->acessos) ?></td>
                <td><?= h($physicalExams->irpm) ?></td>
                <td><?= h($physicalExams->kg) ?></td>
                <td><?= h($physicalExams->mmhg) ?></td>
                <td><?= h($physicalExams->so2) ?></td>
                <td><?= h($physicalExams->alt) ?></td>
                <td><?= h($physicalExams->fc) ?></td>
                <td><?= h($physicalExams->so2_percent) ?></td>
                <td><?= h($physicalExams->so2_tax) ?></td>
                <td><?= h($physicalExams->so2_temp) ?></td>
                <td><?= h($physicalExams->alt_m) ?></td>
                <td><?= h($physicalExams->alt_imc) ?></td>
                <td><?= h($physicalExams->created) ?></td>
                <td><?= h($physicalExams->admission_id) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'PhysicalExams', 'action' => 'view', $physicalExams->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'PhysicalExams', 'action' => 'edit', $physicalExams->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'PhysicalExams', 'action' => 'delete', $physicalExams->id], ['confirm' => __('Are you sure you want to delete # {0}?', $physicalExams->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
    <div class="related">
        <h4><?= __('Related {0}', ['Relevant Complementary Exams']) ?></h4>
        <?php if (!empty($admission->relevant_complementary_exams)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Admission Id</th>
                <th>Created</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($admission->relevant_complementary_exams as $relevantComplementaryExams): ?>
            <tr>
                <td><?= h($relevantComplementaryExams->id) ?></td>
                <td><?= h($relevantComplementaryExams->admission_id) ?></td>
                <td><?= h($relevantComplementaryExams->created) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'RelevantComplementaryExams', 'action' => 'view', $relevantComplementaryExams->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'RelevantComplementaryExams', 'action' => 'edit', $relevantComplementaryExams->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'RelevantComplementaryExams', 'action' => 'delete', $relevantComplementaryExams->id], ['confirm' => __('Are you sure you want to delete # {0}?', $relevantComplementaryExams->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
</div>
