<?php
namespace App\Model\Table;

use App\Model\Entity\PainCharacteristicScreening;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PainCharacteristicScreenings Model
 *
 * @property \Cake\ORM\Association\BelongsTo $PainCharacteristics
 * @property \Cake\ORM\Association\BelongsTo $Screenings
 */
class PainCharacteristicScreeningsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('pain_characteristic_screenings');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('PainCharacteristics', [
            'foreignKey' => 'pain_characteristic_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['pain_characteristic_id'], 'PainCharacteristics'));
        $rules->add($rules->existsIn(['screening_id'], 'Screenings'));
        return $rules;
    }
}
