<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Ventilatory Care Plan']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="ventilatoryCarePlans index col-md-10 columns content">
    <h3>Ventilatory Care Plans</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('hospitalization_id') ?></th>
                <th><?= $this->Paginator->sort('data') ?></th>
                <th><?= $this->Paginator->sort('hora') ?></th>
                <th><?= $this->Paginator->sort('ventilador') ?></th>
                <th><?= $this->Paginator->sort('vaa_diametro') ?></th>
                <th><?= $this->Paginator->sort('pcuff_cl') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($ventilatoryCarePlans as $ventilatoryCarePlan): ?>
            <tr>
                <td><?= $this->Number->format($ventilatoryCarePlan->id) ?></td>
                <td><?= $ventilatoryCarePlan->has('hospitalization') ? $this->Html->link($ventilatoryCarePlan->hospitalization->id, ['controller' => 'Hospitalizations', 'action' => 'view', $ventilatoryCarePlan->hospitalization->id]) : '' ?></td>
                <td><?= h($ventilatoryCarePlan->data) ?></td>
                <td><?= h($ventilatoryCarePlan->hora) ?></td>
                <td><?= $this->Number->format($ventilatoryCarePlan->ventilador) ?></td>
                <td><?= $this->Number->format($ventilatoryCarePlan->vaa_diametro) ?></td>
                <td><?= $this->Number->format($ventilatoryCarePlan->pcuff_cl) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $ventilatoryCarePlan->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $ventilatoryCarePlan->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $ventilatoryCarePlan->id], ['confirm' => __('Are you sure you want to delete # {0}?', $ventilatoryCarePlan->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>