<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Professional']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Users']), ['controller' => 'Users', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['User']), ['controller' => 'Users', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Bundle']), ['controller' => 'Bundle', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Bundle']), ['controller' => 'Bundle', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Medical Opinion Answer']), ['controller' => 'MedicalOpinionAnswer', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Medical Opinion Answer']), ['controller' => 'MedicalOpinionAnswer', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Medical Opinion Requests']), ['controller' => 'MedicalOpinionRequests', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Medical Opinion Request']), ['controller' => 'MedicalOpinionRequests', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Professional Sectors']), ['controller' => 'ProfessionalSectors', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Professional Sector']), ['controller' => 'ProfessionalSectors', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Specialties']), ['controller' => 'Specialties', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Specialty']), ['controller' => 'Specialties', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Areas Of Occupation']), ['controller' => 'AreasOfOccupation', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Areas Of Occupation']), ['controller' => 'AreasOfOccupation', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="professionals index col-md-10 columns content">
    <h3>Professionals</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('cpf') ?></th>
                <th><?= $this->Paginator->sort('telephone') ?></th>
                <th><?= $this->Paginator->sort('user_id') ?></th>
                <th><?= $this->Paginator->sort('concil_number') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($professionals as $professional): ?>
            <tr>
                <td><?= $this->Number->format($professional->id) ?></td>
                <td><?= h($professional->cpf) ?></td>
                <td><?= h($professional->telephone) ?></td>
                <td><?= $professional->has('user') ? $this->Html->link($professional->user->name, ['controller' => 'Users', 'action' => 'view', $professional->user->id]) : '' ?></td>
                <td><?= h($professional->concil_number) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $professional->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $professional->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $professional->id], ['confirm' => __('Are you sure you want to delete # {0}?', $professional->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>