<?php
namespace App\Model\Table;

use App\Model\Entity\InformedConsentForm;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * InformedConsentForms Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class InformedConsentFormsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('informed_consent_forms');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('tipo_tci');

        $validator
            ->allowEmpty('riscos');

        $validator
            ->boolean('paciente_e_responsavel')
            ->allowEmpty('paciente_e_responsavel');

        $validator
            ->allowEmpty('nome_responsavel');

        $validator
            ->allowEmpty('cep_responsavel');

        $validator
            ->allowEmpty('documento_responsavel');

        $validator
            ->allowEmpty('bairro_responsavel');

        $validator
            ->allowEmpty('cidade_responsavel');

        $validator
            ->boolean('procedimento_emergencial')
            ->allowEmpty('procedimento_emergencial');

        $validator
            ->allowEmpty('telefone_do_responsavel');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
