<?php
namespace App\Model\Table;

use App\Model\Entity\BarthelIndex;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * BarthelIndexes Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Barthels
 */
class BarthelIndexesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('barthel_indexes');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Barthels', [
            'foreignKey' => 'barthels_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('alimentacao');

        $validator
            ->allowEmpty('banho');

        $validator
            ->allowEmpty('atividades_rotineiras');

        $validator
            ->allowEmpty('vestir_se');

        $validator
            ->allowEmpty('intestino');

        $validator
            ->allowEmpty('sistema_urinario');

        $validator
            ->allowEmpty('uso_do_banheiro');

        $validator
            ->allowEmpty('transferencia');

        $validator
            ->allowEmpty('mobilidade');

        $validator
            ->allowEmpty('escadas');

        $validator
            ->allowEmpty('total_pontos');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['barthels_id'], 'Barthels'));
        return $rules;
    }
}
