<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Screening Entity.
 *
 * @property int $id
 * @property string $complaint
 * @property string $allergy
 * @property string $pre_existing_diseases
 * @property string $height
 * @property string $weight
 * @property string $pulse
 * @property string $pa
 * @property string $respiration
 * @property string $temperature
 * @property string $saturation
 * @property string $capillary_glycemia
 * @property string $pain_intensity
 * @property string $pain_characteristics
 * @property bool $Electrocardiogram
 * @property string $appraiser_identification
 * @property string $nursing_notes
 * @property string $risk_rating
 * @property \Cake\I18n\Time $created
 * @property int $patient_id
 * @property \App\Model\Entity\Patient $patient
 * @property bool $is_active
 * @property int $unit_id
 * @property \App\Model\Entity\Unit $unit
 * @property \App\Model\Entity\Bundle[] $bundles
 * @property \App\Model\Entity\Hospitalization[] $hospitalizations
 * @property \App\Model\Entity\MedicalCare[] $medical_cares
 */
class Screening extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
