<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * SapsIiiScore Entity.
 *
 * @property int $id
 * @property \Cake\I18n\Time $data_de_realizacao
 * @property \Cake\I18n\Time $created
 * @property bool $active
 * @property string $tempo_de_estadia_antes_a_adimissao_na_uti
 * @property string $origem_intra_hospitalar_antes_da_admissao_na_uti
 * @property bool $terapia_de_cancer
 * @property bool $cancer
 * @property bool $haematological_cancer
 * @property bool $chron
 * @property bool $cirrose
 * @property bool $aids
 * @property bool $uso_das_principais_opcoes_terapeuticas
 * @property bool $admissao_na_uti_foi_planejada
 * @property string $motivo_para_a_admissao_na_uti
 * @property string $status_cirurgica_na_admissao_da_uti
 * @property string $localizacao_anatomica_da_cirurgia
 * @property string $infeccao_aguda_na_admissao_da_uti
 * @property string $gcs_estimado_menor
 * @property string $total_de_bilirubine
 * @property string $temperatura_corporal
 * @property string $creatina
 * @property string $frequencia_cardiaca_mais_alta
 * @property string $leucocitos_menor
 * @property string $concentracao_de_ion_hidrogenio_menor
 * @property string $plaquetas_menor
 * @property string $oxigenacao
 * @property string $pressao_sanguinea_sistolica
 * @property int $pontuacao
 * @property int $probabilidade_de_morte
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 */
class SapsIiiScore extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
