<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * ApacheIiScore Entity.
 *
 * @property int $id
 * @property string $temperatura_retal
 * @property string $pressao_arterial_media_mmhg
 * @property string $frequencia_cardiaca_bpm
 * @property string $frequencia_respiratoria_irpm
 * @property string $apache_ii_scorescol
 * @property string $oxigenacao
 * @property string $fio2_maior_que_0_5_a_ado2
 * @property string $fio2_menor_que_pao2
 * @property string $ph_arterial
 * @property string $sodio_serico
 * @property string $potassio_serico
 * @property string $creatinina_serica_dobrar_pontos_se_ira
 * @property string $hematocrito
 * @property string $numero_de_leucocitos
 * @property string $escala_de_glasgow_para_o_coma_escore
 * @property string $total_do_escore_fisiologico_agudo
 * @property string $bicarbonato_serico
 * @property string $paciente_nao_cirurgicos_ou_pos_operatorios
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 * @property bool $active
 * @property \Cake\I18n\Time $created
 * @property \Cake\I18n\Time $data_realizacao
 */
class ApacheIiScore extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
