<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * Barthels Controller
 *
 * @property \App\Model\Table\BarthelsTable $Barthels
 */
class BarthelsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Barthel');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'ApacheIiScores', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $barthels = $this->paginate($this->Barthels);

        $this->set(compact('barthels'));
        $this->set('_serialize', ['barthels']);
    }

    /**
     * View method
     *
     * @param string|null $id Barthel id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $barthel = $this->Barthels->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('barthel', $barthel);
        $this->set('_serialize', ['barthel']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $barthel = $this->Barthels->newEntity();
        if ($this->request->is('post')) {
            $barthel = $this->Barthels->patchEntity($barthel, $this->request->data);
            if ($this->Barthels->save($barthel)) {
                $this->Flash->success(__('The barthel has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The barthel could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->Barthels->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('barthel', 'hospitalizations'));
        $this->set('_serialize', ['barthel']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Barthel id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $barthel = $this->Barthels->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $barthel = $this->Barthels->patchEntity($barthel, $this->request->data);
            if ($this->Barthels->save($barthel)) {
                $this->Flash->success(__('The barthel has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The barthel could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->Barthels->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('barthel', 'hospitalizations'));
        $this->set('_serialize', ['barthel']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Barthel id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $barthel = $this->Barthels->get($id);
        if ($this->Barthels->delete($barthel)) {
            $this->Flash->success(__('The barthel has been deleted.'));
        } else {
            $this->Flash->error(__('The barthel could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
