<?php
namespace App\Controller\Component;

use Cake\Controller\Component;
use Cake\Log\Log;

/**
 * Authorization component
 */
class PermissionComponent extends Component
{
    public $allow = array(
        "Administrador"  => array
        (
            "users"       => array("add", "index", "view", "edit", "delete", "activate", "desactivate", "login", "addUserToUnit", "listUsersFromUnit"),
            "units"       => array("add", "index", "view", "edit", "delete", "activate", 'desactivate', 'listUsers', "attachUsers", "linkUserToUnit", "unlinkUserFromUnit"),
            "groups"      => array("add", "index", "view", "edit", "delete"),
            "signs"       => array("add", "index", "view", "edit", "delete"),
            "specialties" => array("index", "add", "view", "edit"),
        ),
        "Qualidade"      => array
        (
            "users"                    => array("index", "add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("view"),
            "signs"                    => array("index", "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", 'delete', "selectPatient", "selectPatientEmergency"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "rooms"                    => array("index", "add", "view", "edit", 'delete'),
            "professionals"            => array("index", "add", "view", "edit", 'delete'),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', 'selectHospitalization', 'getProfessionals', 'search'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete'),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete'),
            "HealthInsurancePlans"     => array("index", "add", "view", "edit", 'delete'),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete'),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete'),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete'),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete'),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete'),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete'),
            "CribScores"               => array("index", "add", "view", "edit", 'delete'),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete'),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete'),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete'),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete'),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete'),
            "TciTypes"                 => array("index", "add", "view", "edit", 'delete'),

        )
        ,
        "Usuário"        => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient", "selectPatientEmergency"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "rooms"                    => array("index", "add", "view", "edit", 'delete'),
            "professionals"            => array("index", "add", "view", "edit", 'delete'),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', 'selectHospitalization', 'getProfessionals', 'search'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete'),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete'),
            "HealthInsurancePlans"     => array("index", "add", "view", "edit", 'delete'),
            "Origins"                  => array("index", "add", "view", "edit", 'delete'),
            "Signs"                    => array("index", "add", "view", "edit", 'delete'),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete'),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete'),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete'),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete'),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete'),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete'),
            "CribScores"               => array("index", "add", "view", "edit", 'delete'),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete'),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete'),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete'),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete'),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete'),
            "TciTypes"                 => array("index", "add", "view", "edit", 'delete'),
        ),

        "Médico"         => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete'),
            "rooms"                    => array("index", "add", "view", "edit", 'delete'),
            "professionals"            => array("index", "add", "view", "edit", 'delete'),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', 'selectHospitalization'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete'),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete'),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete'),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete'),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete'),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete'),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete'),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete'),
            "CribScores"               => array("index", "add", "view", "edit", 'delete'),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete'),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete'),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete'),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete'),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete'),
            "TciTypes"                 => array("index", "add", "view", "edit", 'delete'),
        ),

        "Farmacêutico"   => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete'),
            "rooms"                    => array("index", "add", "view", "edit", 'delete'),
            "professionals"            => array("index", "add", "view", "edit", 'delete'),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', 'selectHospitalization'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete'),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete'),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete'),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete'),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete'),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete'),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete'),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete'),
            "CribScores"               => array("index", "add", "view", "edit", 'delete'),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete'),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete'),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete'),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete'),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete'),
            "TciTypes"                 => array("index", "add", "view", "edit", 'delete'),
        ),

        "Enfermeiro"     => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete'),
            "rooms"                    => array("index", "add", "view", "edit", 'delete'),
            "professionals"            => array("index", "add", "view", "edit", 'delete'),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', 'selectHospitalization'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete'),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete'),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete'),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete'),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete'),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete'),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete'),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete'),
            "CribScores"               => array("index", "add", "view", "edit", 'delete'),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete'),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete'),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete'),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete'),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete'),
            "TciTypes"                 => array("index", "add", "view", "edit", 'delete'),
        ),

        "Fisioterapeuta" => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete'),
            "rooms"                    => array("index", "add", "view", "edit", 'delete'),
            "professionals"            => array("index", "add", "view", "edit", 'delete'),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', 'selectHospitalization'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete'),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete'),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete'),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete'),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete'),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete'),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete'),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete'),
            "CribScores"               => array("index", "add", "view", "edit", 'delete'),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete'),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete'),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete'),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete'),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete'),
            "TciTypes"                 => array("index", "add", "view", "edit", 'delete'),
        ),

        "CCIH"           => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete'),
            "rooms"                    => array("index", "add", "view", "edit", 'delete'),
            "professionals"            => array("index", "add", "view", "edit", 'delete'),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', 'selectHospitalization'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete'),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete'),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete'),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete'),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete'),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete'),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete'),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete'),
            "CribScores"               => array("index", "add", "view", "edit", 'delete'),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete'),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete'),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete'),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete'),
            "TciTypes"                 => array("index", "add", "view", "edit", 'delete'),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete'),
        ),

        "SIHDOT"         => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete'),
            "rooms"                    => array("index", "add", "view", "edit", 'delete'),
            "professionals"            => array("index", "add", "view", "edit", 'delete'),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', 'selectHospitalization'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete'),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete'),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete'),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete'),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete'),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete'),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete'),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete'),
            "CribScores"               => array("index", "add", "view", "edit", 'delete'),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete'),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete'),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete'),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete'),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete'),
        ),

        "Administrativo" => array
        (
            "users"                    => array("add", "view", "edit", "activate", "desactivate", 'listUsersFromUnit', 'addUserToUnit', "login", "editUserFromUnit"),
            "units"                    => array("index", "view", "edit", "activate", "desactivate", "selectUnit", 'select'),
            "groups"                   => array("index", "view"),
            "signs"                    => array("index", "view", "edit", "delete"),
            "patients"                 => array("index", "add", "view", "edit", "listPatientsFromUnit", "selectPatient"),
            "specialties"              => array("index", "add", "view", "edit", "listPatientsFromUnit"),
            "sectors"                  => array("index", "add", "view", "edit", 'delete'),
            "rooms"                    => array("index", "add", "view", "edit", 'delete'),
            "professionals"            => array("index", "add", "view", "edit", 'delete'),
            "hospitalizations"         => array("index", "add", "view", "edit", 'delete', 'selectHospitalization'),
            "MedicalOpinionRequests"   => array("index", "add", "view", "edit", 'delete', 'toggleMedicalRequest'),
            "MedicalOpinionAnswers"    => array("index", "add", "view", "edit", 'delete'),
            "DailySafetyChecklists"    => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "SurgicalChecklists"       => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "Diagnostics"              => array("index", "add", "view", "edit", 'delete'),
            "Bundles"                  => array("index", "add", "view", "edit", 'delete'),
            "DailyBundles"             => array("index", "add", "view", "edit", 'delete'),
            "HistoricPatientMovements" => array("index", "add", "view", "edit", 'delete'),
            "PavPreventionBundles"     => array("index", "add", "view", "edit", 'delete'),
            "NutritionalAssessments"   => array("index", "add", "view", "edit", 'delete'),
            "ApacheIiScores"           => array("index", "add", "view", "edit", 'delete'),
            "CribScores"               => array("index", "add", "view", "edit", 'delete'),
            "IdentificationOfRisks"    => array("index", "add", "view", "edit", 'delete'),
            "SupportiveMeasures"       => array("index", "add", "view", "edit", 'delete'),
            "CardiacSurgeryChecklists" => array("index", "add", "view", "edit", 'delete', 'activate', 'desactivate'),
            "NasScores"                => array("index", "add", "view", "edit", 'delete'),
            "SofaEscores"              => array("index", "add", "view", "edit", 'delete'),
            "SnapIiScores"             => array("index", "add", "view", "edit", 'delete'),
        ),
    );

    public $allowEditUser = array(
        "Qualidade"     => array("Qualidade", "Médico", "Farmacêutico", "Executivo"),
        "Usuário"       => array("Usuário"),
        "Administrador" => array("Administrador", "Qualidade", "Médico", "Farmacêutico", "Executivo"),
    );

    //verifica se o usuario tem permissao pra acessar a action
    public function hasPermission($role_name, $controller, $action)
    {
        // Log::write('debug', $role_name);
        // Log::write('debug', $action);
        // Log::write('debug', $controller);

        if (in_array($action, $this->allow[$role_name][$controller])) {
            Log::write('debug', "hasPermission = true, controller = " . $controller . ", action = " .
                $action . ", role_name = " . $role_name);
            return true;
        } else {
            Log::write('debug', "hasPermission = false, controller = " . $controller . ", action = " .
                $action . ", role_name = " . $role_name);
            return false;
        }
    }

    //verifica se o usuario pode editar outro usuario
    public function canEditUser($user_role_name, $target_role_name)
    {
        if (in_array($target_role_name, $this->allowEditUser[$user_role_name])) {
            Log::write('debug', "canEditUser = true, user_role_name = " . $user_role_name . ", target_role_name = "
                . $target_role_name);
            return true;
        } else {
            Log::write('debug', "canEditUser = false, user_role_name = " . $user_role_name . ", target_role_name = "
                . $target_role_name);
            return false;
        }

    }
}
