<?php
namespace App\Model\Table;

use App\Model\Entity\Procedure;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Procedures Model
 *
 * @property \Cake\ORM\Association\BelongsTo $DailySafetyChecklists
 */
class ProceduresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('procedures');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('DailySafetyChecklists', [
            'foreignKey' => 'daily_safety_checklist_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('description', 'create')
            ->notEmpty('description');

        $validator
            ->boolean('can_be_removed')
            ->requirePresence('can_be_removed', 'create')
            ->notEmpty('can_be_removed');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['daily_safety_checklist_id'], 'DailySafetyChecklists'));
        return $rules;
    }
}
