<?php
namespace App\Model\Table;

use App\Model\Entity\Measure;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Measures Model
 *
 * @property \Cake\ORM\Association\BelongsTo $SupportiveMeasures
 */
class MeasuresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('measures');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('SupportiveMeasures', [
            'foreignKey' => 'supportive_measure_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->date('data_insercao')
            ->requirePresence('data_insercao', 'create')
            ->notEmpty('data_insercao');

        $validator
            ->date('previsao_retirada')
            ->allowEmpty('previsao_retirada');

        $validator
            ->allowEmpty('description');

        $validator
            ->allowEmpty('type');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['supportive_measure_id'], 'SupportiveMeasures'));
        return $rules;
    }
}
