<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * IdentificationOfRisk Entity.
 *
 * @property int $id
 * @property \Cake\I18n\Time $created
 * @property bool $is_active
 * @property string $alergia
 * @property bool $ignorancia
 * @property bool $administracao
 * @property bool $reconcializacao
 * @property bool $transporte_inseguro
 * @property bool $identificacao_errada_do_paciente
 * @property bool $controle_inadequado
 * @property bool $perda_da_passagem
 * @property bool $que_do_leito
 * @property bool $turnover
 * @property bool $absenteismo
 * @property bool $nao_parametrizacao_da_monitorizacao
 * @property bool $contaminacao_de_culturas
 * @property bool $coleta_inadequada_de_culturas
 * @property bool $broncoaspiracao
 * @property bool $infeccao_de_corrente
 * @property bool $pneumonia
 * @property bool $infeccao_de_trato
 * @property bool $reacao_transfusional
 * @property bool $nao_acompanhamento
 * @property bool $reinteracao
 * @property bool $extubacao_acidental
 * @property bool $feblite
 * @property bool $dor
 * @property bool $troca_de_pacientes
 * @property bool $fornecimento_de_medicamentos_incorretos
 * @property bool $nao_administracao_de_dietas
 * @property bool $administracao_inadequada_de_dieta
 * @property bool $diarreia
 * @property bool $nao_fornecimento_de_materiais
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 */
class IdentificationOfRisk extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
