<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

/**
 * NutritionalAssessments Controller
 *
 * @property \App\Model\Table\NutritionalAssessmentsTable $NutritionalAssessments
 */
class NutritionalAssessmentsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Permission');
        $this->loadComponent('Upload');
        $this->set('title', 'Avaliação Nutricional');

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'NutritionalAssessments', $action);

        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $nutritionalAssessments = $this->paginate($this->NutritionalAssessments);

        $this->set(compact('nutritionalAssessments'));
        $this->set('_serialize', ['nutritionalAssessments']);
    }

    /**
     * View method
     *
     * @param string|null $id Nutritional Assessment id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $nutritionalAssessment = $this->NutritionalAssessments->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('nutritionalAssessment', $nutritionalAssessment);
        $this->set('_serialize', ['nutritionalAssessment']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $session               = $this->request->session();
        $patient_table         = TableRegistry::get('Patients');
        $hospitalization_table = TableRegistry::get('Hospitalizations');

        $pacient_id         = $session->read('selected-pacient');
        $hospitalization_id = $session->read('selected-hospitalization');

        $patient = $patient_table->get($pacient_id, []);

        $hospitalization = $hospitalization_table->get($hospitalization_id, ['contain' => ['Comorbidities', 'SofaEscores', 'ApacheIiScores']]);

        $nutritionalAssessment = $this->NutritionalAssessments->newEntity();

        if ($this->request->is('post')) {
            $nutritionalAssessment = $this->NutritionalAssessments->patchEntity($nutritionalAssessment, $this->request->data);
            if ($this->NutritionalAssessments->save($nutritionalAssessment)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->NutritionalAssessments->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('nutritionalAssessment', 'hospitalizations', 'patient', 'hospitalization'));
        $this->set('_serialize', ['nutritionalAssessment']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Nutritional Assessment id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {

        $nutritionalAssessment = $this->NutritionalAssessments->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $nutritionalAssessment = $this->NutritionalAssessments->patchEntity($nutritionalAssessment, $this->request->data);
            if ($this->NutritionalAssessments->save($nutritionalAssessment)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->NutritionalAssessments->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('nutritionalAssessment', 'hospitalizations'));
        $this->set('_serialize', ['nutritionalAssessment']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Nutritional Assessment id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $nutritionalAssessment = $this->NutritionalAssessments->get($id);
        if ($this->NutritionalAssessments->delete($nutritionalAssessment)) {
            $this->Flash->success(__('O registro foi salvo.'));
        } else {
            $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
