<?php
namespace App\Model\Table;

use App\Model\Entity\CurbScore;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * CurbScores Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class CurbScoresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('curb_scores');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('presenca_de_confusao_mental')
            ->allowEmpty('presenca_de_confusao_mental');

        $validator
            ->boolean('ureia_acima_de_50')
            ->allowEmpty('ureia_acima_de_50');

        $validator
            ->boolean('frequencia_respiratoria')
            ->allowEmpty('frequencia_respiratoria');

        $validator
            ->boolean('pressao_arterial')
            ->allowEmpty('pressao_arterial');

        $validator
            ->boolean('idade_maior_de_65_anos')
            ->allowEmpty('idade_maior_de_65_anos');

        $validator
            ->date('data_de_realizacao')
            ->requirePresence('data_de_realizacao', 'create')
            ->notEmpty('data_de_realizacao');

        $validator
            ->boolean('active')
            ->allowEmpty('active');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
